/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.impl.Dimension;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;

final class GridGeometryInfo
extends GridGeometry {
    private static final Object[] AXIS_TYPES = new Object[]{"Lon", AttributeNames.LONGITUDE, "Lat", AttributeNames.LATITUDE, "Pressure", AttributeNames.VERTICAL, "Height", AttributeNames.VERTICAL, "RunTime", AttributeNames.TIME, "Time", AttributeNames.TIME};
    private final Dimension[] domain;
    private final VariableInfo[] range;

    GridGeometryInfo(Dimension[] dimensionArray, VariableInfo[] variableInfoArray) {
        this.domain = dimensionArray;
        this.range = variableInfoArray;
    }

    @Override
    public int getSourceDimensions() {
        return this.domain.length;
    }

    @Override
    public int getTargetDimensions() {
        return this.range.length;
    }

    @Override
    public Axis[] getAxes() throws IOException, DataStoreException {
        TreeMap<VariableInfo, Integer> treeMap = new TreeMap<VariableInfo, Integer>();
        for (int i = 0; i < this.range.length; ++i) {
            VariableInfo variableInfo = this.range[i];
            if (treeMap.put(variableInfo, i) == null) continue;
            throw new DataStoreException(Errors.format((short)24, variableInfo.getName()));
        }
        Axis[] axisArray = new Axis[this.range.length];
        for (Map.Entry entry : treeMap.entrySet()) {
            int n;
            int n2 = (Integer)entry.getValue();
            VariableInfo variableInfo = (VariableInfo)entry.getKey();
            AttributeNames.Dimension dimension = null;
            String string = variableInfo.getAxisType();
            if (string != null) {
                for (n = 0; n < AXIS_TYPES.length; n += 2) {
                    if (!string.equalsIgnoreCase((String)AXIS_TYPES[n])) continue;
                    dimension = (AttributeNames.Dimension)AXIS_TYPES[n + 1];
                    break;
                }
            }
            n = 0;
            Dimension[] dimensionArray = variableInfo.dimensions;
            int[] nArray = new int[dimensionArray.length];
            int[] nArray2 = new int[dimensionArray.length];
            block3: for (Dimension dimension2 : dimensionArray) {
                int n3 = this.domain.length;
                while (--n3 >= 0) {
                    if (this.domain[n3] != dimension2) continue;
                    nArray[n] = n3;
                    nArray2[n++] = dimension2.length;
                    continue block3;
                }
            }
            axisArray[n2] = new Axis(this, variableInfo, dimension, ArraysExt.resize(nArray, n), ArraysExt.resize(nArray2, n));
        }
        return axisArray;
    }

    @Override
    protected double coordinateForAxis(Object object, int n, int n2) throws IOException, DataStoreException {
        VariableInfo variableInfo = (VariableInfo)object;
        int n3 = variableInfo.dimensions[0].length;
        return variableInfo.read().doubleValue(n + n3 * n2);
    }
}

