/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.geotiff;

import java.util.ArrayList;
import ucar.nc2.geotiff.FieldType;
import ucar.nc2.geotiff.GeoKey;
import ucar.nc2.geotiff.Tag;

class IFDEntry
implements Comparable {
    protected Tag tag;
    protected FieldType type;
    protected int count;
    protected int[] value;
    protected double[] valueD;
    protected String valueS;
    protected ArrayList geokeys = null;

    public IFDEntry(Tag tag, FieldType type) {
        this.tag = tag;
        this.type = type;
        this.count = 1;
    }

    public IFDEntry(Tag tag, FieldType type, int count) {
        this.tag = tag;
        this.type = type;
        this.count = count;
    }

    public IFDEntry setValue(int v) {
        this.value = new int[1];
        this.value[0] = v;
        return this;
    }

    public IFDEntry setValue(int n, int d) {
        this.value = new int[2];
        this.value[0] = n;
        this.value[1] = d;
        return this;
    }

    public IFDEntry setValue(int n, int d, int f) {
        this.value = new int[3];
        this.value[0] = n;
        this.value[1] = d;
        this.value[2] = f;
        return this;
    }

    public IFDEntry setValue(int[] v) {
        this.count = v.length;
        this.value = (int[])v.clone();
        return this;
    }

    public IFDEntry setValue(double v) {
        this.count = 1;
        this.valueD = new double[1];
        this.valueD[0] = v;
        return this;
    }

    public IFDEntry setValue(double[] v) {
        this.count = v.length;
        this.valueD = (double[])v.clone();
        return this;
    }

    public IFDEntry setValue(String v) {
        this.count = v.length();
        this.valueS = v;
        return this;
    }

    public void addGeoKey(GeoKey geokey) {
        if (this.geokeys == null) {
            this.geokeys = new ArrayList();
        }
        this.geokeys.add(geokey);
    }

    public int compareTo(Object o) {
        return this.tag.compareTo(((IFDEntry)o).tag);
    }

    public String toString() {
        int i;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(" tag = " + this.tag);
        sbuf.append(" type = " + this.type);
        sbuf.append(" count = " + this.count);
        sbuf.append(" values = ");
        if (this.type == FieldType.ASCII) {
            sbuf.append(this.valueS);
        } else if (this.type == FieldType.RATIONAL) {
            for (i = 0; i < 2; i += 2) {
                if (i > 1) {
                    sbuf.append(", ");
                }
                sbuf.append(this.value[i] + "/" + this.value[i + 1]);
            }
        } else if (this.type == FieldType.DOUBLE || this.type == FieldType.FLOAT) {
            for (i = 0; i < this.count; ++i) {
                sbuf.append(this.valueD[i] + " ");
            }
        } else {
            int n = Math.min(this.count, 30);
            for (int i2 = 0; i2 < n; ++i2) {
                sbuf.append(this.value[i2] + " ");
            }
        }
        if (this.geokeys != null) {
            sbuf.append("\n");
            for (i = 0; i < this.geokeys.size(); ++i) {
                GeoKey elem = (GeoKey)this.geokeys.get(i);
                sbuf.append("        " + elem + "\n");
            }
        }
        return sbuf.toString();
    }
}

