#!/usr/bin/perl

package eBay::API::XML::Call::GetItemTransactions::GetItemTransactionsRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetItemTransactionsRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetItemTransactions::GetItemTransactionsRequestType

=head1 DESCRIPTION

Retrieves transaction information for a specified itemID. Depending on
whether the listing sells one or multiple items and on whether anything
has been sold in that listing, this returns zero, one or multiple transactions.
Often, it is more efficient to use GetSellerTransactions instead.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetItemTransactions::GetItemTransactionsRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::PaginationType;
use eBay::API::XML::DataType::Enum::TransactionPlatformCodeType;


my @gaProperties = ( [ 'IncludeContainingOrder', 'xs:boolean', '', '', '' ]
	, [ 'IncludeFinalValueFee', 'xs:boolean', '', '', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'ModTimeFrom', 'xs:dateTime', '', '', '' ]
	, [ 'ModTimeTo', 'xs:dateTime', '', '', '' ]
	, [ 'NumberOfDays', 'xs:int', '', '', '' ]
	, [ 'Pagination', 'ns:PaginationType', ''
	     ,'eBay::API::XML::DataType::PaginationType', '1' ]
	, [ 'Platform', 'ns:TransactionPlatformCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::TransactionPlatformCodeType', '' ]
	, [ 'TransactionID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setIncludeContainingOrder()

Whether to retrieve the order information.
Default is false.
Will not return the ContainingOrder information for an Express transaction that was part of an Express order.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setIncludeContainingOrder {
  my $self = shift;
  $self->{'IncludeContainingOrder'} = shift
}

=head2 isIncludeContainingOrder()

#    Returns: 'xs:boolean'

=cut

sub isIncludeContainingOrder {
  my $self = shift;
  return $self->{'IncludeContainingOrder'};
}


=head2 setIncludeFinalValueFee()

Indicates whether to include final value fees in the response.
For most listing types, the fee is returned in Transaction.FinalValueFee.
For Dutch auctions that end with bids (not Buy It Now purchases), the fee
is returned in Item.SellingStatus.FinalValueFee.
The Final Value Fee for FixedPriceItem, StoresFixedPrice, and Buy It Now
Dutch listing types is returned on a transaction by transaction basis.
For all other listing types, including Chinese and Dutch (no Buy It Now
purchases), the Final Value Fee is returned when the listing status is
Completed.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setIncludeFinalValueFee {
  my $self = shift;
  $self->{'IncludeFinalValueFee'} = shift
}

=head2 isIncludeFinalValueFee()

#    Returns: 'xs:boolean'

=cut

sub isIncludeFinalValueFee {
  my $self = shift;
  return $self->{'IncludeFinalValueFee'};
}


=head2 setItemID()

Unique item ID for the item for which to retrieve transactions.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setModTimeFrom()

Also see NumberOfDays which, if used, takes precedence over ModTimeFrom and
ModTimeTo. If you prefer to use ModTimeFrom and
ModTimeTo, you specify the time range within which
retrieved transactions' statuses were modified.
ModTimeFrom is the earlier (older) date and ModTimeTo is the later (more recent) date.
If you specify this value, and do not specify the other end of the range,
then the time range is 30 days.
The time range between ModTimeFrom to ModTimeTo
cannot be greater than 30 days.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut

sub setModTimeFrom {
  my $self = shift;
  $self->{'ModTimeFrom'} = shift
}

=head2 getModTimeFrom()

#    Returns: 'xs:dateTime'

=cut

sub getModTimeFrom {
  my $self = shift;
  return $self->{'ModTimeFrom'};
}


=head2 setModTimeTo()

Also see NumberOfDays which, if used, takes precedence over ModTimeFrom and
ModTimeTo. If you prefer to use ModTimeFrom and
ModTimeTo, you specify the time range within which
retrieved transactions' statuses were modified.
ModTimeFrom is the earlier (older) date and ModTimeTo is the later (more recent) date.
If you specify this value, and do not specify the other end of the range,
then the time range is 30 days.
The time range between ModTimeFrom to ModTimeTo
cannot be greater than 30 days.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut

sub setModTimeTo {
  my $self = shift;
  $self->{'ModTimeTo'} = shift
}

=head2 getModTimeTo()

#    Returns: 'xs:dateTime'

=cut

sub getModTimeTo {
  my $self = shift;
  return $self->{'ModTimeTo'};
}


=head2 setNumberOfDays()

NumberOfDays enables you to specify the number of days' worth
of new and modified transactions that you want to retrieve.
The call response contains the transactions
whose status was modified within the
specified number of days since the API call was made.
NumberOfDays is often preferable to using
the ModTimeFrom and ModTimeTo filters because you only need to specify
one value.
If you use NumberOfDays, then ModTimeFrom and ModTimeTo are ignored.
For this field, one day is defined as 24 hours.

Max: 30

  RequiredInput: No
#    Argument: 'xs:int'

=cut

sub setNumberOfDays {
  my $self = shift;
  $self->{'NumberOfDays'} = shift
}

=head2 getNumberOfDays()

#    Returns: 'xs:int'

=cut

sub getNumberOfDays {
  my $self = shift;
  return $self->{'NumberOfDays'};
}


=head2 setPagination()

Child elements control pagination of the output. Use its EntriesPerPage
property to control the number of transactions to return per call and its
PageNumber property to specify the page of data to return.

  RequiredInput: No
#    Argument: 'ns:PaginationType'

=cut

sub setPagination {
  my $self = shift;
  $self->{'Pagination'} = shift
}

=head2 getPagination()

#    Returns: 'ns:PaginationType'

=cut

sub getPagination {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Pagination'
		,'eBay::API::XML::DataType::PaginationType');
}


=head2 setPlatform()

Name of the eBay co-branded site upon which the transaction was made.
This will serve as a filter for the transactions to get emitted in the response.

  RequiredInput: No
#    Argument: 'ns:TransactionPlatformCodeType'

=cut

sub setPlatform {
  my $self = shift;
  $self->{'Platform'} = shift
}

=head2 getPlatform()

#    Returns: 'ns:TransactionPlatformCodeType'

=cut

sub getPlatform {
  my $self = shift;
  return $self->{'Platform'};
}


=head2 setTransactionID()

Identifies one transaction for a listing.
For Chinese auctions listings (single-item listings for which there can be
only one transaction), TransactionID is always 0, and for multi-quantity
listings (for which there can be multiple transactions), TransactionID has
a non-0 value.
To determine the valid transaction IDs
for a listing, you typically need to have previously executed GetItemTransactionsCall
or GetSellerTransactionsCall and stored all the listing's transactions.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setTransactionID {
  my $self = shift;
  $self->{'TransactionID'} = shift
}

=head2 getTransactionID()

#    Returns: 'xs:string'

=cut

sub getTransactionID {
  my $self = shift;
  return $self->{'TransactionID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
