# Generated by default/object.tt
package Paws::GlueDataBrew::S3TableOutputOptions;
  use Moose;
  has Location => (is => 'ro', isa => 'Paws::GlueDataBrew::S3Location', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::S3TableOutputOptions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::S3TableOutputOptions object:

  $service_obj->Method(Att1 => { Location => $value, ..., Location => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::S3TableOutputOptions object:

  $result = $service_obj->Method(...);
  $result->Att1->Location

=head1 DESCRIPTION

Represents options that specify how and where DataBrew writes the S3
output generated by recipe jobs.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Location => L<Paws::GlueDataBrew::S3Location>

Represents an Amazon S3 location (bucket name and object key) where
DataBrew can write output from a job.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

