use Unicode::Collate::CJK::Korean;
+{
   locale_version => 1.01,
   overrideCJK => \&Unicode::Collate::CJK::Korean::weightKorean,
   entry => <<'ENTRY', # for DUCET v6.3.0
F967      ; [.3159.0021.0002.4E0D][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.3159.0032.0002.4E26][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.3152.0021.0002.4E32][.31D8.0020.0002][.3243.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.3164.0021.0002.4E38][.31D9.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.3155.0021.0002.4E39][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95E
F91B      ; [.3157.0021.0002.4E82][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.3157.0021.0002.4E86][.31DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.3157.0021.0002.4EAE][.31D2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.315B.0021.0002.4EC0][.31E4.0020.0002][.323E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FD
F9A8      ; [.3157.0021.0002.4EE4][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A8
F92D      ; [.3157.0021.0002.4F86][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.3157.0021.0002.4F8B][.31D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.3158.0021.0002.4FAE][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.3158.0021.0002.4FAE][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F805
2F806     ; [.3162.0023.0002.4FBB][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F806
F965      ; [.3163.0021.0002.4FBF][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F965
2F807     ; [.3159.0022.0002.5002][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F807
F9D4      ; [.3157.0022.0002.502B][.31E1.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F809     ; [.3159.0022.0002.5099][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.315B.0023.0002.50CF][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.3157.0022.0002.50DA][.31DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.315B.0023.0002.50E7][.31E2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.315B.0023.0002.50E7][.31E2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.315D.0021.0002.5140][.31D8.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.3160.0021.0002.5145][.31DD.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.3158.0021.0002.514D][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.3158.0021.0002.514D][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F814     ; [.3154.0022.0002.5167][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F814
FA72      ; [.315E.0024.0002.5168][.31D4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.3157.0023.0002.5169][.31D2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.3157.0021.0002.516D][.31E1.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.3152.0026.0002.5177][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.3152.0024.0002.5180][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.315E.0021.0002.518D][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.3158.0022.0002.5192][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.3158.0022.0002.5195][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.315D.0023.0002.5197][.31DC.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.315D.003B.0002.51A4][.31DE.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.3155.0022.0002.51AC][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81A
F92E      ; [.3157.0021.0002.51B7][.31D1.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.3157.0024.0002.51C9][.31D2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.3157.0021.0002.51CC][.31E2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.3157.0021.0002.51DC][.31E2.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F954
FA15      ; [.3164.0022.0002.51DE][.31E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA15
2F81E     ; [.315D.0023.0002.5203][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.315E.0021.0002.5207][.31D4.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.315E.0021.0002.5207][.31D4.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.3157.0022.0002.5217][.31D6.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.3157.0022.0002.5229][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.315E.0022.0002.523A][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.3152.0021.0002.523B][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F822     ; [.3164.0021.0002.5272][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F822
2F823     ; [.315B.002D.0002.5277][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F823
F9C7      ; [.3157.0021.0002.5289][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.3157.0021.0002.529B][.31D6.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.3157.0023.0002.52A3][.31D6.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99D
FA76      ; [.315D.0024.0002.52C7][.31DC.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.315D.0024.0002.52C7][.31DC.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.3158.0023.0002.52C9][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.3158.0023.0002.52C9][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.3157.0021.0002.52D2][.31E2.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.3157.0021.0002.52DE][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.3152.0023.0002.52E4][.31E2.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.3152.0023.0002.52E4][.31E2.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.3157.0023.0002.52F5][.31D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.315E.0022.0002.52FA][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.315E.0022.0002.52FA][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.3163.0022.0002.5305][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F829
F963      ; [.3159.0021.0002.5317][.31DD.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.3159.0021.0002.5317][.31DD.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.3154.0021.0002.533F][.31E4.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.3164.0021.0002.5349][.31DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.3159.0025.0002.5351][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.3159.0025.0002.5351][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.3159.0022.0002.535A][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.315E.0022.0002.5373][.31E2.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.3157.0022.0002.5375][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F830     ; [.315E.0021.0002.537D][.31E2.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F830
2F831     ; [.3152.0028.0002.537F][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.3152.0028.0002.537F][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.3152.0028.0002.537F][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.3160.0022.0002.53C3][.31D0.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.3152.0022.0002.53CA][.31E2.0020.0002][.323E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.315B.005E.0002.53DF][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.3152.002A.0002.53E5][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.3152.0021.0002.53EB][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.315E.0022.0002.53F1][.31E4.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83A
F9DE      ; [.3157.0024.0002.540F][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.3157.0021.0002.541D][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.3164.0021.0002.5438][.31E2.0020.0002][.323E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.3157.0024.0002.5442][.31D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.315E.0026.0002.5448][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.315E.0028.0002.5468][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F840     ; [.315D.0031.0002.54A2][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.315D.0025.0002.54BD][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F842     ; [.3155.0021.0002.5510][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.3152.0022.0002.5553][.31D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F843
2F844     ; [.3164.0024.0002.5563][.31D0.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.315B.0024.0002.5584][.31D4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.315B.0024.0002.5584][.31D4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.3157.0021.0002.5587][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.3164.0022.0002.5599][.31DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.3164.0022.0002.5599][.31DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.3152.0022.0002.559D][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.3152.0022.0002.559D][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.3153.0021.0002.55AB][.31E4.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F848
FA7B      ; [.315D.0022.0002.55E2][.31D8.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7B
FA37      ; [.3162.0022.0002.5606][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.3162.0022.0002.5606][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84C
FA38      ; [.3152.0026.0002.5668][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.3159.0023.0002.5674][.31DD.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.3157.0023.0002.56F9][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.3155.0024.0002.5716][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F855     ; [.3164.0024.0002.578B][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.315B.0021.0002.57CE][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.315B.0021.0002.57F4][.31E4.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F857     ; [.3159.0023.0002.5831][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F857
FA39      ; [.3159.0033.0002.5840][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.3160.0022.0002.585A][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.3160.0022.0002.585A][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.315B.0021.0002.585E][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.3158.0021.0002.58A8][.31DD.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3A
FA7D      ; [.3159.0024.0002.58B3][.31DD.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.3157.0021.0002.58D8][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.3157.0021.0002.58DF][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F942
2F85C     ; [.3159.0032.0002.5906][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85C
2F85D     ; [.3155.0021.0002.591A][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.3158.0021.0002.5922][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.315D.0024.0002.5944][.31D4.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.3154.0023.0002.5948][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.3152.0024.0002.5951][.31D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.3159.0025.0002.5954][.31DD.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.315B.0030.0002.5962][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.3154.0021.0002.5973][.31D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F981
2F862     ; [.3164.0026.0002.59EC][.31E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F862
2F863     ; [.315D.002C.0002.5A1B][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F863
2F864     ; [.3162.0030.0002.5A27][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F864
FA80      ; [.3159.0027.0002.5A62][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.3159.002B.0002.5A66][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F986     ; [.315D.0025.0002.5AB5][.31E4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F986
2F869     ; [.315D.0041.0002.5B08][.31DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F869
FA81      ; [.315E.003C.0002.5B28][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA81
2F86A     ; [.3157.0029.0002.5B3E][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.3157.0029.0002.5B3E][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.3155.0021.0002.5B85][.31D1.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.315D.0029.0002.5BC3][.31DE.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86D
2F86E     ; [.3160.003B.0002.5BD8][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86E
F95F      ; [.3154.0021.0002.5BE7][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.3154.0021.0002.5BE7][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.3154.0021.0002.5BE7][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.3157.0023.0002.5BEE][.31DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BC
F9BD      ; [.3154.0021.0002.5C3F][.31DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.3155.0028.0002.5C60][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F877
F94B      ; [.3157.0023.0002.5C62][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94B
FA3B      ; [.3160.0021.0002.5C64][.31E2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.3157.0026.0002.5C65][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DF
2F879     ; [.315B.002A.0002.5CC0][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F879
F9D5      ; [.3157.0023.0002.5D19][.31E1.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D5
F921      ; [.3157.0021.0002.5D50][.31D0.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F921
F9AB      ; [.3157.0025.0002.5DBA][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.315B.0021.0002.5DE1][.31DD.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.315B.0027.0002.5DE2][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.315B.0022.0002.5DFD][.31D8.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F885     ; [.315B.0029.0002.5E28][.31D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F885
2F886     ; [.3158.0025.0002.5E3D][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F886
F98E      ; [.3154.0021.0002.5E74][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.3155.002B.0002.5EA6][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88C     ; [.3159.0052.0002.5EB3][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.315B.0025.0002.5EB6][.31D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.3157.0021.0002.5EC9][.31D6.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.3157.0021.0002.5ECA][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.3157.0021.0002.5ECA][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA0B      ; [.3152.0021.0002.5ED3][.31D9.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0B
F982      ; [.3157.0025.0002.5EEC][.31D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F982
F943      ; [.3157.0022.0002.5F04][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F943
2F894     ; [.3155.004B.0002.5F22][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F894
2F895     ; [.3155.004B.0002.5F22][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F895
2F899     ; [.3164.0025.0002.5F62][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.3160.0025.0002.5F69][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.315E.0027.0002.5F6B][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.3157.0021.0002.5F8B][.31E1.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D8
F966      ; [.3159.0026.0002.5FA9][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.315D.0043.0002.5FAD][.31DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.315D.002A.0002.5FCD][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.315E.0026.0002.5FD7][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.3154.0021.0002.5FF5][.31D6.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A3
F960      ; [.3154.0024.0002.6012][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.3157.0026.0002.601C][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AC
2F8A0     ; [.315D.0042.0002.6081][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.3164.0026.0002.6094][.31DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.3164.0026.0002.6094][.31DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.3155.0022.0002.60C7][.31D8.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.3158.002D.0002.60D8][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.315D.0025.0002.60E1][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.315D.002E.0002.6108][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.3157.0022.0002.6144][.31E1.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.315E.002A.0002.6148][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.3164.0027.0002.614C][.31D9.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.3164.0027.0002.614C][.31D9.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA8A      ; [.315D.0047.0002.6160][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8A
FA3E      ; [.3152.0028.0002.6168][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3E
2F8AA     ; [.3157.0031.0002.617A][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AA
FA3F      ; [.315E.0022.0002.618E][.31E2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.315E.0022.0002.618E][.31E2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.315E.0022.0002.618E][.31E2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.3157.0021.0002.6190][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.3159.0028.0002.61A4][.31DD.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AE     ; [.3160.0030.0002.61AF][.31D0.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AE
2F8AC     ; [.3164.0021.0002.61B2][.31D4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
2F8AF     ; [.3158.0025.0002.61DE][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AF
FA40      ; [.315E.0022.0002.61F2][.31E4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.315E.0022.0002.61F2][.31E4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.315E.0022.0002.61F2][.31E4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.3157.0022.0002.61F6][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.3157.0022.0002.61F6][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.3157.0022.0002.6200][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.315B.0026.0002.6210][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
F9D2      ; [.3157.0022.0002.622E][.31E1.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.3155.0029.0002.6234][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B5     ; [.3163.002B.0002.62B1][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.3157.0021.0002.62C9][.31D0.0020.0002][.323E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.3154.0024.0002.62CF][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.3160.0026.0002.62D3][.31D4.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.3159.0022.0002.62D4][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
F973      ; [.315B.0022.0002.62FE][.31E2.0020.0002][.323E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.3158.0027.0002.633D][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.315D.0027.0002.6350][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.315B.0039.0002.6368][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.3154.0024.0002.637B][.31D6.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.315B.0029.0002.6383][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.3157.0021.0002.63A0][.31D2.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.315D.0025.0002.63A9][.31D4.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.315D.0030.0002.63C4][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8D
FA8E      ; [.315B.0030.0002.641C][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8BF     ; [.315E.0025.0002.6422][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BF
2F8C3     ; [.3158.0021.0002.6469][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
F991      ; [.3154.0022.0002.649A][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F991
2F8C5     ; [.3164.0029.0002.649D][.31E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C5
F930      ; [.3157.0023.0002.64C4][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F930
FA41      ; [.3158.0025.0002.654F][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.3158.0025.0002.654F][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.315D.0030.0002.6556][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.3152.0030.0002.656C][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.315B.0032.0002.6578][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.3157.0025.0002.6599][.31DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.3157.0028.0002.65C5][.31D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F983
2F8CB     ; [.3152.0035.0002.65E3][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CB
F9E0      ; [.315D.0024.0002.6613][.31D6.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.315E.0026.0002.6649][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.3160.0022.0002.6674][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.3160.0022.0002.6674][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.3164.002A.0002.6688][.31DD.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.315B.002B.0002.6691][.31D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.315B.002B.0002.6691][.31D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
FA06      ; [.3163.0022.0002.66B4][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA06
F98B      ; [.3157.0022.0002.66C6][.31D6.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98B
F901      ; [.3152.0033.0002.66F4][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.315B.002D.0002.66F8][.31D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.3160.0023.0002.6700][.31DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.3157.0022.0002.6717][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.3157.0022.0002.6717][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.3157.0022.0002.6717][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.3158.0025.0002.671B][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.3158.0025.0002.671B][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
F9E1      ; [.3157.0028.0002.674E][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.3163.0025.0002.6753][.31DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.315E.002E.0002.6756][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.3152.0038.0002.675E][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9C8      ; [.3154.0021.0002.677B][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C8
F9F4      ; [.3157.0021.0002.6797][.31E4.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.3157.0023.0002.67F3][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C9
F9DA      ; [.3157.0023.0002.6817][.31E1.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DA
F97A      ; [.3157.0025.0002.6881][.31D2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.3158.0027.0002.6885][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.3158.0027.0002.6885][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
F9E2      ; [.3157.0029.0002.68A8][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E8     ; [.315B.0062.0002.6942][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8EA     ; [.3152.002A.0002.69EA][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EA
F914      ; [.315D.0028.0002.6A02][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.315D.0028.0002.6A02][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.315D.0028.0002.6A02][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.3157.0024.0002.6A13][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94C
F931      ; [.3157.0024.0002.6AD3][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.315E.0021.0002.6ADB][.31E2.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.3157.0023.0002.6B04][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.3160.0028.0002.6B21][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.3164.0025.0002.6B54][.31D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
2F8F3     ; [.315B.0023.0002.6B72][.31D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F3
F98C      ; [.3157.0023.0002.6B77][.31D6.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98C
F9A5      ; [.3157.0023.0002.6BAE][.31D6.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A5
F970      ; [.315B.0023.0002.6BBA][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.315B.0023.0002.6BBA][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.315B.0023.0002.6BBA][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8FA     ; [.3159.0025.0002.6C4E][.31D4.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
F972      ; [.3160.0024.0002.6C88][.31E4.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.315D.002B.0002.6CBF][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.3163.0024.0002.6CCC][.31E4.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F968
F9E3      ; [.3154.0022.0002.6CE5][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E3
F915      ; [.3157.0021.0002.6D1B][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.3155.002A.0002.6D1E][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F900     ; [.3163.0029.0002.6D3E][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.3157.0025.0002.6D41][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.3157.0025.0002.6D41][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.3157.0025.0002.6D41][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.3164.002E.0002.6D69][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.3157.0023.0002.6D6A][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.3164.002A.0002.6D77][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.3164.002A.0002.6D77][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.3160.0025.0002.6D78][.31E4.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.315D.0022.0002.6D85][.31D6.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.3157.0022.0002.6DCB][.31E4.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F94D      ; [.3157.0025.0002.6DDA][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94D
F9D6      ; [.3157.0024.0002.6DEA][.31E1.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.315D.0026.0002.6DF9][.31D4.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.315E.002C.0002.6E1A][.31D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.3164.002B.0002.6E2F][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.315D.002B.0002.6E6E][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.3157.0026.0002.6E9C][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.3154.0022.0002.6EBA][.31E4.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EC
FA99      ; [.315E.002B.0002.6ECB][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.315E.002B.0002.6ECB][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.3164.0022.0002.6ED1][.31D9.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F904
F94E      ; [.3157.0026.0002.6F0F][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.3164.0026.0002.6F22][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.3164.0026.0002.6F22][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.3157.0024.0002.6F23][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.315E.0033.0002.6F6E][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.3159.003C.0002.6FC6][.31DD.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.3157.0025.0002.6FEB][.31D0.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.3157.002A.0002.6FFE][.31D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.315D.002D.0002.701B][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.315E.003D.0002.701E][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.315E.003D.0002.701E][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F835     ; [.3164.002D.0002.7070][.31DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F918     ; [.315E.002B.0002.707D][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.315E.002C.0002.7099][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.3162.0028.0002.70AD][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.3157.0025.0002.70C8][.31D6.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.3157.0022.0002.70D9][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F916
F993      ; [.3157.0025.0002.7149][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.315E.002D.0002.716E][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.315E.002D.0002.716E][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9C
F9C0      ; [.3157.0026.0002.71CE][.31DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.3157.0023.0002.71D0][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.3157.0027.0002.7210][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.3157.0026.0002.721B][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.3160.0036.0002.7228][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA9E      ; [.315E.0028.0002.7235][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.315E.0028.0002.7235][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F921
F946      ; [.3157.0023.0002.7262][.31DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.315B.0030.0002.7280][.31D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F924
FA9F      ; [.3159.0027.0002.72AF][.31D4.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F9FA      ; [.315B.0035.0002.72C0][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FA
F92B      ; [.3157.0024.0002.72FC][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.315E.002E.0002.732A][.31D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.315E.002E.0002.732A][.31D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.3157.0021.0002.7375][.31D6.0020.0002][.323E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.3155.0023.0002.737A][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.315B.0021.0002.7387][.31D8.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.315B.0021.0002.7387][.31D8.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.315D.0025.0002.738B][.31D9.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F929
F9AD      ; [.3157.0027.0002.73B2][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.3157.0023.0002.73DE][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.3157.002D.0002.7406][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.3157.0028.0002.7409][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.3162.002B.0002.7422][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92F     ; [.315D.003D.0002.745C][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.3164.002D.0002.7469][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AE
FAA1      ; [.315E.0057.0002.7471][.31D4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA1
2F930     ; [.315E.0057.0002.7471][.31D4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F930
F994      ; [.3157.0026.0002.7489][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F994
F9EF      ; [.3157.0024.0002.7498][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EF
2F932     ; [.3152.003A.0002.74CA][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F932
F9CD      ; [.3157.002A.0002.7559][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.3157.0022.0002.7565][.31D2.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.315D.002C.0002.7570][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.315D.002C.0002.7570][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.3157.002F.0002.75E2][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.315D.0059.0002.7610][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA5      ; [.315D.0023.0002.761F][.31D8.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.3157.0027.0002.7642][.31DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.3157.0023.0002.7669][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.315D.0022.0002.76CA][.31E4.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.315D.0022.0002.76CA][.31E4.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.315B.002B.0002.76DB][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.3157.0028.0002.76E7][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.315E.0021.0002.76F4][.31E4.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.315E.0021.0002.76F4][.31E4.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.315B.002C.0002.7701][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.315E.0033.0002.771E][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F945
FAAA      ; [.3160.0023.0002.7740][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAA
2F94A     ; [.315E.0034.0002.778B][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94A
F9CE      ; [.3157.002C.0002.786B][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.3157.0021.0002.788C][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.3157.0021.0002.788C][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.3159.0038.0002.7891][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.3157.0024.0002.78CA][.31DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F947
F964      ; [.3159.0032.0002.78FB][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F964
F985      ; [.3157.002B.0002.792A][.31D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F985
FA4C      ; [.315B.0046.0002.793E][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.3152.004C.0002.7948][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.315E.0035.0002.7949][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.315D.0032.0002.7950][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.315E.0039.0002.7956][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.315E.0039.0002.7956][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.3160.0023.0002.795D][.31DD.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.315B.002C.0002.795E][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.315B.0037.0002.7965][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.3157.0022.0002.797F][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.3164.0027.0002.798D][.31D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.315E.0044.0002.798E][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.3159.0028.0002.798F][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.3159.0028.0002.798F][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.3157.0023.0002.79AE][.31D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F995      ; [.3154.0023.0002.79CA][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F995
2F957     ; [.3160.0024.0002.79EB][.31DD.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F957
F956      ; [.3157.0023.0002.7A1C][.31E2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.3152.0025.0002.7A40][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.3152.0025.0002.7A40][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F959
FA55      ; [.3155.0022.0002.7A81][.31D8.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA55
F9F7      ; [.3157.0022.0002.7ACB][.31E4.0020.0002][.323E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F7
F9F8      ; [.3157.0023.0002.7B20][.31E4.0020.0002][.323E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.315E.0027.0002.7BC0][.31D4.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.315E.0027.0002.7BC0][.31D4.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.315E.003D.0002.7BC6][.31D4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.3160.0026.0002.7BC9][.31DD.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.3157.0025.0002.7C3E][.31D6.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.3157.0026.0002.7C60][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F944
F9F9      ; [.3157.0024.0002.7C92][.31E4.0020.0002][.323E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.315E.0047.0002.7CBE][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1D
FA03      ; [.3155.0029.0002.7CD6][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA03
F97B      ; [.3157.0029.0002.7CE7][.31D2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F96A     ; [.3152.004F.0002.7D00][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.3154.0022.0002.7D10][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.315B.0023.0002.7D22][.31D1.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.3157.0028.0002.7D2F][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.315E.0063.0002.7D5B][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.3159.0034.0002.7D63][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F93D      ; [.3157.0023.0002.7DA0][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93D
F957      ; [.3157.0024.0002.7DBE][.31E2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.3160.0030.0002.7DC7][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.3157.0027.0002.7DF4][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.3157.0027.0002.7DF4][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.3157.0027.0002.7DF4][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB0
FA58      ; [.315E.0036.0002.7E09][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.3157.0029.0002.7E37][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.3159.0026.0002.7E41][.31D4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA59
2F970     ; [.315B.0052.0002.7E45][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F970
FAB1      ; [.3159.0035.0002.7F3E][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB1
FA5A      ; [.315B.0035.0002.7F72][.31D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.3157.0031.0002.7F79][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E6
F90F      ; [.3157.0024.0002.7F85][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90F
F9AF      ; [.3157.0029.0002.7F9A][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.315D.0036.0002.7FBD][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1E
2F979     ; [.3152.005A.0002.7FFA][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F979
F934      ; [.3157.0029.0002.8001][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.315E.0033.0002.8005][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.315E.0033.0002.8005][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.315E.0033.0002.8005][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.3157.002B.0002.8046][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B0
F997      ; [.3157.0028.0002.806F][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.3160.0028.0002.8070][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.3157.0027.0002.807E][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.3157.0022.0002.808B][.31E2.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.3154.0023.0002.80AD][.31DD.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.315D.0024.0002.80B2][.31E1.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F985     ; [.3159.003F.0002.813E][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.3157.0022.0002.81D8][.31D0.0020.0002][.323E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.3157.0024.0002.81E8][.31E4.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.3160.002A.0002.81ED][.31E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.315D.002E.0002.8201][.31D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.315D.002E.0002.8201][.31D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98B
F97C      ; [.3157.002A.0002.826F][.31D2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97C
2F990     ; [.315D.0037.0002.828B][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F991     ; [.315E.003B.0002.829D][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.3164.0029.0002.82B1][.31D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.3159.0035.0002.82B3][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.315D.0029.0002.82BD][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.315D.0023.0002.82E5][.31D2.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.315D.0023.0002.82E5][.31D2.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.3152.003A.0002.82E6][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F999     ; [.3160.002E.0002.831D][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F999
2F99C     ; [.315D.004C.0002.8323][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.3155.0022.0002.8336][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.3164.0034.0002.8352][.31D9.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F99D     ; [.3158.002A.0002.83BD][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99D
F93E      ; [.3157.0024.0002.83C9][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93E
2F9A1     ; [.3152.0023.0002.83CA][.31DD.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.3152.0025.0002.83CC][.31E1.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.3160.0029.0002.83DC][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
FAB4      ; [.3164.002A.0002.83EF][.31D9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.3157.0025.0002.83F1][.31E2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.3157.0025.0002.843D][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.315D.0023.0002.8449][.31D6.0020.0002][.323E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.315E.0034.0002.8457][.31D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.315E.0034.0002.8457][.31D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.3157.0029.0002.84EE][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F999
2F9A8     ; [.3163.002A.0002.84F1][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A8
F9C2      ; [.3157.002A.0002.84FC][.31DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AC     ; [.315D.0062.0002.8564][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
F923      ; [.3157.0028.0002.85CD][.31D0.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.3157.0025.0002.85FA][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.3157.002A.0002.8606][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F935
F91F      ; [.3157.0027.0002.862D][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.3157.0025.0002.863F][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.3164.0023.0002.8650][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.3157.002B.0002.865C][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.3157.002B.0002.865C][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.3164.0025.0002.8667][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B7     ; [.3160.0034.0002.86A9][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
2F9BC     ; [.315E.0026.0002.8728][.31D4.0020.0002][.323E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9BC
F911      ; [.3157.0026.0002.87BA][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F911
F927      ; [.3157.0023.0002.881F][.31D0.0020.0002][.323E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F927
FA08      ; [.3164.0025.0002.884C][.31D1.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C4     ; [.315D.0030.0002.8863][.31E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.3157.0026.0002.88C2][.31D6.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.3157.0034.0002.88CF][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E7
F9E8      ; [.3157.0035.0002.88E1][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.3157.0027.0002.88F8][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F912
FA60      ; [.3152.0028.0002.8910][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.3152.0034.0002.8941][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.3157.0029.0002.8964][.31D0.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.3159.002D.0002.8986][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.3152.0028.0002.898B][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.315B.0037.0002.8996][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.315B.0037.0002.8996][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.315B.0031.0002.8AA0][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
F96F      ; [.315B.002B.0002.8AAA][.31D4.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96F
F9A1      ; [.315B.002B.0002.8AAA][.31D4.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A1
FAB9      ; [.315E.0046.0002.8ABF][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.3160.0026.0002.8ACB][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.3157.002B.0002.8AD2][.31D2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.3157.0021.0002.8AD6][.31D8.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.315D.0046.0002.8AED][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.315D.0046.0002.8AED][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.315E.0030.0002.8AF8][.31D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.315E.0030.0002.8AF8][.31D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.3154.0021.0002.8AFE][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.3154.0021.0002.8AFE][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.315D.0022.0002.8B01][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.315D.0022.0002.8B01][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.3152.002D.0002.8B39][.31E2.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.3152.002D.0002.8B39][.31E2.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.315B.002C.0002.8B58][.31E4.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.3155.002A.0002.8B80][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.3159.0023.0002.8B8A][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.3159.0023.0002.8B8A][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.3152.0057.0002.8C48][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.315B.003B.0002.8C55][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.3152.002E.0002.8CAB][.31D9.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.3159.0032.0002.8CC1][.31DD.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.3157.0025.0002.8CC2][.31DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.3152.0039.0002.8CC8][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.3159.002D.0002.8CD3][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.315E.002B.0002.8D08][.31E2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.315E.002B.0002.8D08][.31E2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D6     ; [.3152.0039.0002.8D1B][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D6
2F9D7     ; [.3152.0058.0002.8D77][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DA     ; [.3159.0027.0002.8DCB][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.3157.002C.0002.8DEF][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F937
F902      ; [.3160.002D.0002.8ECA][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F902
F998      ; [.3157.002A.0002.8F26][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.3157.0026.0002.8F2A][.31E1.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.315B.004F.0002.8F38][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.315B.004F.0002.8F38][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.3159.002F.0002.8F3B][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.3157.0026.0002.8F62][.31D6.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98D
F971      ; [.315E.003E.0002.8FB0][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F971
F99A      ; [.3157.002B.0002.9023][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.315D.0027.0002.9038][.31E4.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.315D.0027.0002.9038][.31E4.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.315E.0041.0002.9072][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.3157.002B.0002.907C][.31DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.3157.0028.0002.908F][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F913
FA2E      ; [.3157.0028.0002.90DE][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2E
FA26      ; [.3155.0045.0002.90FD][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA26
F919      ; [.3157.0026.0002.916A][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F919
F9B7      ; [.3157.0024.0002.91B4][.31D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.3157.0036.0002.91CC][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.3157.002D.0002.91CF][.31D2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.3152.0021.0002.91D1][.31E4.0020.0002][.323D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.3157.002D.0002.9234][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9E7     ; [.3159.002F.0002.9238][.31D0.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E7
2F9EA     ; [.3159.0039.0002.927C][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EA
2F9E8     ; [.3164.003F.0002.92D7][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9E8
F93F      ; [.3157.0025.0002.9304][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93F
F99B      ; [.3157.002C.0002.934A][.31D6.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99B
2F9EE     ; [.3152.0033.0002.958B][.31D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.3157.002E.0002.95AD][.31D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F986
F9C6      ; [.315D.0031.0002.962E][.31D9.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.3157.002D.0002.964B][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.3152.0037.0002.964D][.31D0.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.3157.0026.0002.9675][.31E2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.3157.0023.0002.9678][.31E1.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D3
FAC6      ; [.315E.004E.0002.967C][.31D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC6
F9DC      ; [.3157.0021.0002.9686][.31E1.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.3157.0027.0002.96A3][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F1
FA2F      ; [.3157.0025.0002.96B7][.31D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2F
F9B8      ; [.3157.0026.0002.96B8][.31D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B8
F9EA      ; [.3157.0038.0002.96E2][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.3154.0023.0002.96E3][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.3154.0023.0002.96E3][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.3157.002E.0002.96F6][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.3157.0028.0002.96F7][.31DB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F949
2F9F5     ; [.315D.0031.0002.9723][.31DD.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9F5
F938      ; [.3157.002E.0002.9732][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.3157.002F.0002.9748][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.315E.0054.0002.9756][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.315E.0054.0002.9756][.31D4.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC8
2F9FA     ; [.3163.0034.0002.97E0][.31E4.0020.0002][.3235.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9FA
FA69      ; [.3164.0026.0002.97FF][.31D2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.3164.0026.0002.97FF][.31D2.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACA
F9B4      ; [.3157.0030.0002.9818][.31D6.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B4
FA6A      ; [.3159.002E.0002.983B][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.3159.002E.0002.983B][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.3157.002E.0002.985E][.31E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.3152.005B.0002.98E2][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.3159.0039.0002.98EF][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.315B.005A.0002.98FC][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.3152.0030.0002.9928][.31D9.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2C
F91A      ; [.3157.0027.0002.99F1][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91A
F987      ; [.3157.0030.0002.9A6A][.31D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F987
FACD      ; [.315E.004C.0002.9B12][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACD
2FA0A     ; [.315E.004C.0002.9B12][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA0A
F939      ; [.3157.002F.0002.9B6F][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F939
F9F2      ; [.3157.0028.0002.9C57][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F2
FA2D      ; [.3164.0025.0002.9DB4][.31D0.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.3157.0030.0002.9DFA][.31D8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.3157.0028.0002.9E1E][.31D0.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.3157.0026.0002.9E7F][.31D8.0020.0002][.322E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.3157.0031.0002.9E97][.31D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.3157.0029.0002.9E9F][.31E4.0020.0002][.3231.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.3158.0028.0002.9EBB][.31D0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.3157.0032.0002.9ECE][.31D6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA1C     ; [.3159.004A.0002.9F3B][.31E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
F9C4      ; [.3157.0021.0002.9F8D][.31DC.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C4
FAD9      ; [.3157.002E.0002.9F8E][.31D8.0020.0002][.3242.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAD9
F907      ; [.3152.0056.0002.9F9C][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.3152.0056.0002.9F9C][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.3152.0056.0002.9F9C][.31DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACE
ENTRY
};
