/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.Rule;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;

public class BinaryRule
extends Rule
implements Serializable,
Comparable {
    public int leftChild = -1;
    public int rightChild = -1;
    private int hashCode = -1;
    private static final char[] charsToEscape = new char[]{'\"'};
    private transient String cached = null;
    private static final long serialVersionUID = 1L;

    public BinaryRule() {
    }

    public BinaryRule(int parent, int leftChild, int rightChild) {
        this.parent = parent;
        this.leftChild = leftChild;
        this.rightChild = rightChild;
    }

    public BinaryRule(int parent, int leftChild, int rightChild, double score) {
        this.parent = parent;
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.score = (float)score;
    }

    public BinaryRule(String s, Numberer n) {
        String[] fields = StringUtils.splitOnCharWithQuoting(s, ' ', '\"', '\\');
        this.parent = n.number(fields[0]);
        this.leftChild = n.number(fields[2]);
        this.rightChild = n.number(fields[3]);
        this.score = Float.parseFloat(fields[4]);
    }

    public int hashCode() {
        if (this.hashCode < 0) {
            this.hashCode = this.parent << 16 ^ this.leftChild << 8 ^ this.rightChild;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BinaryRule) {
            BinaryRule br = (BinaryRule)o;
            if (this.parent == br.parent && this.leftChild == br.leftChild && this.rightChild == br.rightChild) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        Numberer n = Numberer.getGlobalNumberer("states");
        return "\"" + StringUtils.escapeString(n.object(this.parent).toString(), charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(n.object(this.leftChild).toString(), charsToEscape, '\\') + "\" \"" + StringUtils.escapeString(n.object(this.rightChild).toString(), charsToEscape, '\\') + "\" " + this.score;
    }

    public String toStringNoScore() {
        if (this.cached == null) {
            Numberer n = Numberer.getGlobalNumberer("states");
            this.cached = "\"" + StringUtils.escapeString(n.object(this.parent).toString(), charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(n.object(this.leftChild).toString(), charsToEscape, '\\') + "\" \"" + StringUtils.escapeString(n.object(this.rightChild).toString(), charsToEscape, '\\');
        }
        return this.cached;
    }

    public int compareTo(Object o) {
        BinaryRule ur = (BinaryRule)o;
        if (this.parent < ur.parent) {
            return -1;
        }
        if (this.parent > ur.parent) {
            return 1;
        }
        if (this.leftChild < ur.leftChild) {
            return -1;
        }
        if (this.leftChild > ur.leftChild) {
            return 1;
        }
        if (this.rightChild < ur.rightChild) {
            return -1;
        }
        if (this.rightChild > ur.rightChild) {
            return 1;
        }
        return 0;
    }
}

