/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** Clownfish::CFC::Binding::C - Generate code for C bindings.
 */
#ifndef H_CFCC
#define H_CFCC

#ifdef __cplusplus
extern "C" {
#endif

typedef struct CFCC CFCC;
struct CFCClass;
struct CFCHierarchy;
struct CFCUri;

/**
 * @param hierarchy A L<Clownfish::CFC::Model::Hierarchy>.
 * @param header Text which will be prepended to each generated C file --
 * typically, an "autogenerated file" warning.
 * @param footer Text to be appended to the end of each generated C file --
 * typically copyright information.
 */
CFCC*
CFCC_new(struct CFCHierarchy *hierarchy, const char *header,
         const char *footer);

CFCC*
CFCC_init(CFCC *self, struct CFCHierarchy *hierarchy, const char *header,
          const char *footer);

void
CFCC_destroy(CFCC *self);

/** Write the "cfish_hostdefs.h" header file.
 */
void
CFCC_write_hostdefs(CFCC *self);

/** Write the HTML documentation.
 */
void
CFCC_write_html_docs(CFCC *self);

/** Write all man pages.
 */
void
CFCC_write_man_pages(CFCC *self);

char*
CFCC_link_text(struct CFCUri *uri_obj);

#ifdef __cplusplus
}
#endif

#endif /* H_CFCC */

