# This code is part of Perl distribution HTML-FromMail version 4.00.
# The POD got stripped from this file by OODoc version 3.05.
# For contributors see file ChangeLog.

# This software is copyright (c) 2003-2025 by Mark Overmeer.

# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
# SPDX-License-Identifier: Artistic-1.0-Perl OR GPL-1.0-or-later


package HTML::FromMail::Default::HTMLifiers;{
our $VERSION = '4.00';
}


use strict;
use warnings;

use Log::Report 'html-frommail';

use HTML::FromText ();

#--------------------

our @htmlifiers = (
	'text/plain' => \&htmlifyText,
#	'text/html'  => \&htmlifyHtml,
);


sub htmlifyText($$$$)
{	my ($page, $message, $part, $args) = @_;
	my $main     = $args->{main} or panic;
	my $settings = $main->settings('HTML::FromText')
	  || +{ pre => 1, urls => 1, email => 1, bold => 1, underline => 1};

	my $f = HTML::FromText->new($settings)
		or panic "cannot create an HTML::FromText object";

	 +{	image => '',            # this is not an image
		html  => { text => $f->parse($part->decoded->string) },
	  };
}


1;
