# Generated by default/object.tt
package Paws::SSMIncidents::RegionInfo;
  use Moose;
  has SseKmsKeyId => (is => 'ro', isa => 'Str', request_name => 'sseKmsKeyId', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest'], required => 1);
  has StatusMessage => (is => 'ro', isa => 'Str', request_name => 'statusMessage', traits => ['NameInRequest']);
  has StatusUpdateDateTime => (is => 'ro', isa => 'Str', request_name => 'statusUpdateDateTime', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::RegionInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::RegionInfo object:

  $service_obj->Method(Att1 => { SseKmsKeyId => $value, ..., StatusUpdateDateTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::RegionInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->SseKmsKeyId

=head1 DESCRIPTION

Information about a Region in your replication set.

=head1 ATTRIBUTES


=head2 SseKmsKeyId => Str

The ID of the KMS key used to encrypt the data in this Region.


=head2 B<REQUIRED> Status => Str

The status of the Region in the replication set.


=head2 StatusMessage => Str

Information displayed about the status of the Region.


=head2 B<REQUIRED> StatusUpdateDateTime => Str

The most recent date and time that the Region's status was updated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

