/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabeledWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.ling.WordLemmaTag;
import edu.stanford.nlp.ling.WordTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Sentence {
    private Sentence() {
    }

    public static ArrayList<TaggedWord> toTaggedList(List<String> lex, List<String> tags) {
        int ts;
        ArrayList<TaggedWord> sent = new ArrayList<TaggedWord>();
        int ls = lex.size();
        if (ls != (ts = tags.size())) {
            throw new IllegalArgumentException("Sentence.toSentence: lengths differ");
        }
        for (int i = 0; i < ls; ++i) {
            sent.add(new TaggedWord(lex.get(i), tags.get(i)));
        }
        return sent;
    }

    public static ArrayList<Word> toUntaggedList(List<String> lex) {
        ArrayList<Word> sent = new ArrayList<Word>();
        int ls = lex.size();
        for (int i = 0; i < ls; ++i) {
            sent.add(new Word(lex.get(i)));
        }
        return sent;
    }

    public static List<HasWord> toWordList(List<String> lex) {
        ArrayList<HasWord> sent = new ArrayList<HasWord>();
        for (String str : lex) {
            CoreLabel cl = new CoreLabel();
            cl.setValue(str);
            cl.setWord(str);
            sent.add(cl);
        }
        return sent;
    }

    public static ArrayList<Word> toUntaggedList(String ... words) {
        ArrayList<Word> sent = new ArrayList<Word>();
        for (String str : words) {
            sent.add(new Word(str));
        }
        return sent;
    }

    public static List<HasWord> toWordList(String ... words) {
        ArrayList<HasWord> sent = new ArrayList<HasWord>();
        for (String word : words) {
            CoreLabel cl = new CoreLabel();
            cl.setValue(word);
            cl.setWord(word);
            sent.add(cl);
        }
        return sent;
    }

    public static List<CoreLabel> toCoreLabelList(String ... words) {
        ArrayList<CoreLabel> sent = new ArrayList<CoreLabel>();
        for (String word : words) {
            CoreLabel cl = new CoreLabel();
            cl.setValue(word);
            cl.setWord(word);
            sent.add(cl);
        }
        return sent;
    }

    public static <T> String listToString(List<T> list) {
        return Sentence.listToString(list, true);
    }

    public static <T> String listToString(List<T> list, boolean justValue) {
        return Sentence.listToString(list, justValue, null);
    }

    public static <T> String listToString(List<T> list, boolean justValue, String separator) {
        StringBuilder s = new StringBuilder();
        Iterator<T> wordIterator = list.iterator();
        while (wordIterator.hasNext()) {
            T o = wordIterator.next();
            s.append(Sentence.wordToString(o, justValue, separator));
            if (!wordIterator.hasNext()) continue;
            s.append(' ');
        }
        return s.toString();
    }

    public static <T> String wordToString(T o, boolean justValue) {
        return Sentence.wordToString(o, justValue, null);
    }

    public static <T> String wordToString(T o, boolean justValue, String separator) {
        if (justValue && o instanceof Label) {
            if (o instanceof CoreLabel) {
                CoreLabel l = (CoreLabel)o;
                String w = l.value();
                if (w == null) {
                    w = l.word();
                }
                return w;
            }
            return ((Label)o).value();
        }
        if (o instanceof CoreLabel) {
            CoreLabel l = (CoreLabel)o;
            String w = l.value();
            if (w == null) {
                w = l.word();
            }
            if (l.tag() != null) {
                if (separator == null) {
                    return w + "/" + l.tag();
                }
                return w + separator + l.tag();
            }
            return w;
        }
        if (separator != null && o instanceof TaggedWord) {
            return ((TaggedWord)o).toString(separator);
        }
        if (separator != null && o instanceof LabeledWord) {
            return ((LabeledWord)o).toString(separator);
        }
        if (separator != null && o instanceof WordLemmaTag) {
            return ((WordLemmaTag)o).toString(separator);
        }
        if (separator != null && o instanceof WordTag) {
            return ((WordTag)o).toString(separator);
        }
        return o.toString();
    }

    public static <T> String extractNgram(List<T> list, int start, int end) {
        if (start < 0 || end > list.size() || start >= end) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end; ++i) {
            T o = list.get(i);
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(o instanceof HasWord ? ((HasWord)o).word() : o.toString());
        }
        return sb.toString();
    }
}

