package Net::Amazon::EMR::InstanceGroupStatus;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Moose::Util::TypeConstraints;
use Net::Amazon::EMR::Coercions;
use Net::Amazon::EMR::InstanceGroupStateChangeReason;
use Net::Amazon::EMR::InstanceGroupTimeline;

subtype 'Net::Amazon::EMR::Type::InstanceGroupStatus::State' => as 'Str' => where { m/^(?:PROVISIONING | BOOTSTRAPPING | RUNNING | RESIZING | SUSPENDED | TERMINATING | TERMINATED | ARRESTED | SHUTTING_DOWN | ENDED)$/x };

has 'State' => ( is => 'ro',
                isa => 'Net::Amazon::EMR::Type::InstanceGroupStatus::State',
);

has 'StateChangeReason' => ( is => 'ro', 
                             isa => 'Net::Amazon::EMR::Type::InstanceGroupStateChangeReason',
                             coerce => 1,
                         );

has 'Timeline' => ( is => 'ro', 
                    isa => 'Net::Amazon::EMR::Type::InstanceGroupTimeline',
                    coerce => 1,
                );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::InstanceGroupStatus

=head1 DESCRIPTION

Implements the InstanceGroupStatus data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_InstanceGroupStatus.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
