use ExtUtils::MakeMaker;
use Config;

my $is_64bit  = $Config{uvsize} >= 8;

# Cannot build if we don't have 64bit UVs
if (!$is_64bit) {
	die("This module requires that Perl be built with 64bit integer support (--64int)\n");
}

WriteMakefile(
	NAME             => 'Random::RDTSC',
	VERSION_FROM     => 'lib/Random/RDTSC.pm',
	ABSTRACT         => 'RDTSC Random in Perl',
	XSMULTI          => 1,
	AUTHOR           => 'Scott Baker <bakerscot@cpan.org>',
	LICENSE          => 'mit',
	MIN_PERL_VERSION => '5.016',
	LIBS             => [''],
	DEFINE           => '',
	INC              => '-Ilib',

	PREREQ_PM          => { 'ExtUtils::MakeMaker' => '7.12', },
	CONFIGURE_REQUIRES => { 'ExtUtils::MakeMaker' => '7.12', },
	TEST_REQUIRES      => { 'Test::More' => '0', },

	META_MERGE => {
		dynamic_config => 1,
		'meta-spec' => { version => 2 },
		resources => {
			repository => {
				url => 'https://github.com/scottchiefbaker/perl-Random-RDTSC.git',
				web => 'https://github.com/scottchiefbaker/perl-Random-RDTSC',
				type => 'git'
			},
			bugtracker => {
				"web" => "https://github.com/scottchiefbaker/perl-Random-RDTSC/issues"
			},
		}
	},

);
