package Daje::Workflow::GenerateSchema::Activity;
use Mojo::Base 'Daje::Workflow::Common::Activity::Base', -base, -signatures;

use Mojo::JSON qw{to_json};
use Daje::Workflow::GenerateSchema::Create::Schema;
use Daje::Workflow::GenerateSchema::Create::Database;
use Mojo::Pg;


# NAME
# ====
#
# Daje::Workflow::GenerateSchema::Activity - It pulls the schema out of a postgres database
#
# SYNOPSIS
# ========
#
#     use Daje::Workflow::GenerateSchema::Activity;
#
# DESCRIPTION
# ===========
#
# Daje::Workflow::GenerateSchema::Activity is ...
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#
#
#

our $VERSION = "0.12";

has 'pg';
has 'dbname';

sub process ($self) {

    $self->_create_database();
    my $schema = $self->_load_db_schema();

    $self->_save_json($schema);

    $self->_drop_database();

    return 1;
}

sub _drop_database($self) {

    my $database = Daje::Workflow::GenerateSchema::Create::Database->new(
        context => $self->context,
        dbname  => $self->dbname(),
    );
}

sub _create_database($self) {

    my $database = Daje::Workflow::GenerateSchema::Create::Database->new(
        context => $self->context,
    );

    $database->create();

    $self->pg($database->pg);
    $self->dbname($database->dbname);
}

sub _load_db_schema($self) {

    my $dbschema = Daje::Workflow::GenerateSchema::Create::Schema->new(
        db       => $self->pg->db,
        excludes => $self->activity_data->{excludes},
    )->get_db_schema('public');

    return $dbschema;
}

sub _save_json($self, $schema) {

    my $data->{data} = to_json($schema);
    $data->{file} = "schema";
    my @data;
    push(@data, $data);
    $self->context->{context}->{schema} = \@data;
}

1;
__END__





#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::GenerateSchema::Activity - It pulls the schema out of a postgres database



=head1 SYNOPSIS


    use Daje::Workflow::GenerateSchema::Activity;



=head1 DESCRIPTION


Daje::Workflow::GenerateSchema::Activity is ...



=head1 REQUIRES

L<Mojo::Pg> 

L<Daje::Workflow::GenerateSchema::Create::Database> 

L<Daje::Workflow::GenerateSchema::Create::Schema> 

L<Mojo::JSON> 

L<Mojo::Base> 


=head1 METHODS

=head2 process

 process();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>





=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

