# Generated by default/object.tt
package Paws::CloudWatchEvents::CapacityProviderStrategyItem;
  use Moose;
  has Base => (is => 'ro', isa => 'Int', request_name => 'base', traits => ['NameInRequest']);
  has CapacityProvider => (is => 'ro', isa => 'Str', request_name => 'capacityProvider', traits => ['NameInRequest'], required => 1);
  has Weight => (is => 'ro', isa => 'Int', request_name => 'weight', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::CapacityProviderStrategyItem

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::CapacityProviderStrategyItem object:

  $service_obj->Method(Att1 => { Base => $value, ..., Weight => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::CapacityProviderStrategyItem object:

  $result = $service_obj->Method(...);
  $result->Att1->Base

=head1 DESCRIPTION

The details of a capacity provider strategy. To learn more, see
CapacityProviderStrategyItem
(https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CapacityProviderStrategyItem.html)
in the Amazon ECS API Reference.

=head1 ATTRIBUTES


=head2 Base => Int

The base value designates how many tasks, at a minimum, to run on the
specified capacity provider. Only one capacity provider in a capacity
provider strategy can have a base defined. If no value is specified,
the default value of 0 is used.


=head2 B<REQUIRED> CapacityProvider => Str

The short name of the capacity provider.


=head2 Weight => Int

The weight value designates the relative percentage of the total number
of tasks launched that should use the specified capacity provider. The
weight value is taken into consideration after the base value, if
defined, is satisfied.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

