#
#
#

use Test::Simple tests => 4;

use Games::Maze;

my $last_dir = $Games::Maze::North;

my $correct_make = 
q(    __    __    __    __    __    __
   /  \__/  \__/  \__/  \__/  \__/f \  
/  \__    __    __    __      /  \__/  
\     \__/  \__/  \__/  \__/f \   f \  
/  \__    __   \     \     \__/  \__/  
\  /  \__   \__   \  /  \  /  \  /f \  
/  \     \__   \__/  \  /  \     \  /  
\  /  \  /  \__   \__   \  /  \__/  \  
/  \  /  \     \__   \__/  \  /  \__/  
\  /  \  /  \  /  \__   \__   \   f \  
/  \  /  \  /  \     \__   \__/  \__/  
\  /  \  /  \  /  \  /  \__    __/f \  
/  \  /  \  /  \  /  \     \__    __/  
\  /  \  /  \  /  \  /  \  /  \__ f \  
/   __/   __/   __/   __/   __   \__/  
\__/  \__/  \__/  \__/  \__/  \__/     
                                       

    __    __    __    __    __    __
 __/  \__/  \__/  \__/  \__/  \__/c \  
/   __    __    __    __    __   \  /  
\  /  \__/  \__/  \__/  \__/c \  /c \  
/  \     \     \     \     \  /  \__/  
\  /  \  /  \  /  \  /  \  /  \  /c \  
/  \  /  \  /  \  /  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /  \  
/  \  /  \  /  \  /  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /c \  
/  \  /  \  /  \  /  \  /  \  /  \__/  
\  /  \  /  \  /  \  /  \  /  \  /c \  
/  \  /  \  /  \  /  \  /  \  /  \__/  
\  /  \  /  \  /  \  /  \  /  \  /b \  
/   __/   __/   __/   __/   __/f \__/  
\__/  \__/  \__/  \__/  \__/  \__/     
                                       

    __    __    __    __    __    __
 __/  \__/  \__/  \__/  \__/  \__/  \  
/   __    __    __    __    __      /  
\  /  \__/  \__/  \__/  \__/  \__/  \  
/  \     \     \     \     \     \  /  
\  /  \  /  \  /  \  /  \  /  \  /  \  
/  \  /  \  /  \  /  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /  \  
/  \  /  \  /  \  /  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /  \  
/  \  /  \  /  \  /  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /  \  
/  \  /  \  /  \  /  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /c \  
/   __/   __/   __/   __/   __/c \  /  
\__/  \__/  \__/  \__/  \__/  \__/     
                                       
);

my $correct_solve = 
q(    __    __    __    __    __    __
   /  \__/  \__/  \__/  \__/  \__/f \  
/ *\__    __    __    __      /  \__/  
\    *\__/  \__/  \__/  \__/f \   f \  
/  \__  * __   \     \     \__/  \__/  
\  /  \__  *\__   \  /  \  /  \  /f \  
/  \     \__  *\__/  \  /  \     \  /  
\  /  \  /  \__  *\__   \  /  \__/  \  
/  \  /  \     \__  *\__/  \  /  \__/  
\  /  \  /  \  /  \__  *\__   \   f \  
/  \  /  \  /  \     \__  *\__/  \__/  
\  /  \  /  \  /  \  /  \__  * __/f \  
/  \  /  \  /  \  /  \     \__  * __/  
\  /  \  /  \  /  \  /  \  /  \__ f*\  
/   __/   __/   __/   __/   __   \__/  
\__/  \__/  \__/  \__/  \__/  \__/     
                                       

    __    __    __    __    __    __
 __/  \__/  \__/  \__/  \__/  \__/c \  
/   __    __    __    __    __   \  /  
\  /  \__/  \__/  \__/  \__/c \  /c \  
/  \     \     \     \     \  /  \__/  
\  /  \  /  \  /  \  /  \  /  \  /c \  
/  \  /  \  /  \  /  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /  \  
/  \  /  \  /  \  /  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /c \  
/  \  /  \  /  \  /  \  /  \  /  \__/  
\  /  \  /  \  /  \  /  \  /  \  /c \  
/  \  /  \  /  \  /  \  /  \  /  \__/  
\  /  \  /  \  /  \  /  \  /  \  /b*\  
/   __/   __/   __/   __/   __/f \__/  
\__/  \__/  \__/  \__/  \__/  \__/     
                                       

    __    __    __    __    __    __
 __/  \__/  \__/  \__/  \__/  \__/  \  
/   __    __    __    __    __      /  
\  /  \__/  \__/  \__/  \__/  \__/  \  
/  \     \     \     \     \     \  /  
\  /  \  /  \  /  \  /  \  /  \  /  \  
/  \  /  \  /  \  /  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /  \  
/  \  /  \  /  \  /  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /  \  
/  \  /  \  /  \  /  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /  \  
/  \  /  \  /  \  /  \  /  \  /  \  /  
\  /  \  /  \  /  \  /  \  /  \  /c*\  
/   __/   __/   __/   __/   __/c \  /  
\__/  \__/  \__/  \__/  \__/  \__/     
                                       
);

my $correct_hex =
q( 0028 002a 000a 0002 000a 0002 000a 0002 000a 0002 000a 0002 000a 0020
 0028 8061 0040 0102 0048 0102 0048 0102 0048 0102 0028 0060 0200 0020
 0028 0021 8042 8142 0048 0042 0060 0022 0060 0022 0201 0021 0202 0020
 0028 0021 0060 0022 8042 8042 0003 0041 0021 0021 0060 0003 0220 0020
 0028 0021 0021 0021 0060 0022 8042 8042 0003 0041 0021 0060 0001 0020
 0028 0021 0021 0021 0021 0021 0060 0022 8042 8042 0003 0009 0202 0020
 0028 0021 0021 0021 0021 0021 0021 0021 0060 0022 8142 8142 0208 0020
 0028 0101 0009 0101 0009 0101 0009 0101 0009 0101 0048 0002 8202 0028
 0028 000a 0028 000a 0028 000a 0028 000a 0028 000a 0028 000a 0028 0022

 0028 000a 000a 0002 000a 0002 000a 0002 000a 0002 000a 0002 000a 0020
 0028 0120 0048 0102 0048 0102 0048 0102 0048 0102 0048 0022 0030 0020
 0028 0021 0060 0022 0060 0022 0060 0022 0060 0022 0030 0021 0011 0020
 0028 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0030 0020
 0028 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0020
 0028 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0011 0020
 0028 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0010 0020
 0028 0101 0009 0101 0009 0101 0009 0101 0009 0101 0009 0201 8210 0028
 0028 000a 0028 000a 0028 000a 0028 000a 0028 000a 0028 000a 0028 0022

 0028 000a 000a 0002 000a 0002 000a 0002 000a 0002 000a 0002 000a 0020
 0028 0120 0048 0102 0048 0102 0048 0102 0048 0102 0048 0102 0028 0020
 0028 0021 0060 0022 0060 0022 0060 0022 0060 0022 0060 0022 0021 0020
 0028 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0020
 0028 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0020
 0028 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0020
 0028 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0021 0020
 0028 0101 0009 0101 0009 0101 0009 0101 0009 0101 0009 0011 8031 0028
 0028 000a 0028 000a 0028 000a 0028 000a 0028 000a 0028 000a 0028 0022
);

my $minos = Games::Maze->new(
		dimensions => [12, 7, 3], cell => 'hex', upcolumn_even => 1,
		entry => [1,1,1], exit => [12,7,3],
		start => [1,6,1], fn_choosedir => \&no_turning
		);

$minos->make();
my $maze_form = $minos->to_ascii();
ok(($maze_form eq $correct_make), "->make() check");

$minos->solve();
$maze_form = $minos->to_ascii();
ok(($maze_form eq $correct_solve), "->solve() check");

$maze_form = $minos->to_hex_dump();
ok(($maze_form eq $correct_hex), "->to_hex_dump() check");

$minos->unsolve();
$maze_form = $minos->to_ascii();
ok(($maze_form eq $correct_make), "->unsolve() check");

exit(0);

sub no_turning
{
	foreach my $d (@{$_[0]})
	{
		return $last_dir = $d if ($last_dir <= $d);
	}
	return ${$_[0]}[0];
}
