use 5.14.0;

package Map::Metro::Plugin::Map::Budapest;

our $VERSION = '0.1000'; # VERSION
# ABSTRACT: Map::Metro map for Budapest

use Moose;
with 'Map::Metro::Plugin::Map';

has '+mapfile' => (
    default => 'map-budapest.metro',
);
sub map_version {
    return $VERSION;
}
sub map_package {
    return __PACKAGE__;
}

1;

__END__

=pod

=encoding utf-8

=head1 NAME

Map::Metro::Plugin::Map::Budapest - Map::Metro map for Budapest

=head1 VERSION

Version 0.1000, released 2015-01-08.

=head1 SYNOPSIS

    use Map::Metro;
    my $graph = Map::Metro->new('Budapest')->parse;

Or

	$ map-metro.pl route Budapest "II. János Pál pápa tér" "Opera"

=head1 DESCRIPTION

See L<Map::Metro> for usage information.

=head1 Status

L<Map::Metro::Plugin::Map::Budapest::Lines>

This map consists of:

=over 4

=item *

The four metro lines [L<wikipedia|https://en.wikipedia.org/wiki/Budapest_Metro>]

=back

=for HTML <p><a href="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Budapest/master/static/images/budapest.png"><img src="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Budapest/master/static/images/budapest.png" style="max-width: 600px" /></a></p>

=head1 SOURCE

L<https://github.com/Csson/p5-Map-Metro-Budapest>

=head1 HOMEPAGE

L<https://metacpan.org/release/Map-Metro-Plugin-Map-Budapest>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
