#!/usr/bin/env perl
use strict;
use warnings;

use Test::More tests => 1;
use Test::Deep;
use Test::MockModule;

use Git::Wrapper::More;

my @dum_ret = (
    qw!
        c4a366176b77e806b2b1a3d19f93a74acd05c599
        f7a158f3b18507648ac619b81cee9dd541e0967c
        b2d4a587657498b29da88d23f7ce020d3ccee0ce
        93e8568719a76d80f07b4e8030436814df9c9444
        01ce5198cd93dd8fb1b8e04528638c98f81c2113
        !
);

my $mgwm = Test::MockModule->new('Git::Wrapper');
$mgwm->mock(
    'rev_list',
    sub {
        my $self = shift;
        return @dum_ret;
    },
);

my $gwm = Git::Wrapper::More->new( dir => '/dummy/dir' );

my @ret = $gwm->lastmergecommit('7bb3fbb155453fc46af866feb58dfe3008356635');

my @expected = (qw!c4a366176b77e806b2b1a3d19f93a74acd05c599!);

cmp_deeply( \@ret, \@expected,
    'lastmergecommit returns the most recent merge commit among those supplied from Git::Wrapper rev-list'
);

exit;

__END__
