# $Id: Tk.pm,v 1.2 1994/12/06 17:32:10 mbeattie Exp $
#
# $Log: Tk.pm,v $
# Revision 1.2  1994/12/06  17:32:10  mbeattie
# none
#
# Revision 1.3  1994/11/12  23:29:55  mbeattie
# *** empty log message ***
#
# Revision 1.1  1994/11/12  18:11:05  mbeattie
# Initial revision
#

package Tcl::Tk;

require Tcl;
use Exporter;
use DynaLoader;

@ISA = (Exporter, DynaLoader);

@EXPORT = qw(frame toplevel label button checkbutton radiobutton scale
	     message listbox scrollbar entry menu menubutton canvas text
	     MainLoop after destroy focus grab lower option place raise
	     selection tk tkbind tkpack tkwait update winfo wm);

$tkinterp = undef;		# this gets defined when "new" is done

sub new {
    my ($class, $name, $display, $sync) = @_;
    die 'Usage: $interp = new Tcl::Tk([$name [, $display [, $sync]]])'
	if @_ > 4;
    die "Tcl::Tk interpreter already created" if defined($tkinterp);
    my($i, $arg);

    $display = $ENV{DISPLAY} unless defined($display);
    ($name = $0) =~ s{.*/}{} unless defined($name);

    $i = new Tcl;
    $i->CreateMainWindow($display, $name, $sync);
    $i->SetVar2("env", "DISPLAY", $display, $Tcl::GLOBAL_ONLY);
    $i->SetVar("argv0", $0, $Tcl::GLOBAL_ONLY);
    $i->SetVar("argc", scalar(@main::ARGV), $Tcl::GLOBAL_ONLY);
    $i->ResetResult();
    foreach $arg (@main::ARGV) {
	$i->AppendElement($arg);
    }
    $i->SetVar("argv", $i->result(), $Tcl::GLOBAL_ONLY);
    $i->SetVar("tcl_interactive", "0", $Tcl::GLOBAL_ONLY);
    $i->Init();
    $i->Tk_Init();

    $tkinterp = $i;	# record the interp in package-scope var $tkinterp
    return $i;
}

sub frame {
    my $path = $tkinterp->call("frame", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub toplevel {
    my $path = $tkinterp->call("toplevel", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub label {
    my $path = $tkinterp->call("label", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub button {
    my $path = $tkinterp->call("button", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub checkbutton {
    my $path = $tkinterp->call("checkbutton", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub radiobutton {
    my $path = $tkinterp->call("radiobutton", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub scale {
    my $path = $tkinterp->call("scale", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub message {
    my $path = $tkinterp->call("message", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub listbox {
    my $path = $tkinterp->call("listbox", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub scrollbar {
    my $path = $tkinterp->call("scrollbar", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub entry {
    my $path = $tkinterp->call("entry", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub menu {
    my $path = $tkinterp->call("menu", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub menubutton {
    my $path = $tkinterp->call("menubutton", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub canvas {
    my $path = $tkinterp->call("canvas", @_);
    bless \$path, Tcl::Tk::Widget;
}
sub text {
    my $path = $tkinterp->call("text", @_);
    bless \$path, Tcl::Tk::Widget;
}

sub after { $tkinterp->call("after", @_) }
sub destroy { $tkinterp->call("destroy", @_) }
sub focus { $tkinterp->call("focus", @_) }
sub grab { $tkinterp->call("grab", @_) }
sub lower { $tkinterp->call("lower", @_) }
sub option { $tkinterp->call("option", @_) }
sub place { $tkinterp->call("place", @_) }
sub raise { $tkinterp->call("raise", @_) }
sub selection { $tkinterp->call("selection", @_) }
sub tk { $tkinterp->call("tk", @_) }
sub tkwait { $tkinterp->call("tkwait", @_) }
sub update { $tkinterp->call("update", @_) }
sub winfo { $tkinterp->call("winfo", @_) }
sub wm { $tkinterp->call("wm", @_) }

sub tkbind { $tkinterp->call("bind", @_) }
sub tkpack { $tkinterp->call("pack", @_) }

package Tcl::Tk::Widget;

sub DESTROY {}			# do not let AUTOLOAD catch this method

sub AUTOLOAD {
    my $w = shift;
    my $method = $AUTOLOAD;
    $method =~ s/^Tcl::Tk::Widget::// or die "weird inheritance";
    $Tcl::Tk::tkinterp->call($$w, $method, @_);
}

bootstrap TclTk;

1;
