Article 24294 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:24294
Newsgroups: comp.lang.perl
Path: feenix.metronet.com!news.ecn.bgu.edu!psuvax1!news.pop.psu.edu!news.cac.psu.edu!howland.reston.ans.net!swrinde!pipex!uunet!timbuk.cray.com!driftwood.cray.com!roehrich
From: roehrich@cray.com (Dean Roehrich)
Subject: Eroot persistent object update
Message-ID: <1994Nov21.181440.18985@driftwood.cray.com>
Lines: 882
Nntp-Posting-Host: poplar017
Organization: Cray Research, Inc.
Date: 21 Nov 94 18:14:40 CST

This is an update to my Eroot persistent object package.  The eroot package
has been moved to Class::Eroot.pm to fit the Perl5 library naming scheme.
The package is still EROOT so the only thing that changes is the require().

This contains an updated Class.pm.  The new version has been renamed to
Class::Template.pm.  The Eroot package has been updated for this.

Also contains a test script (the last time I sent Eroot out the test script
did not work, this time it does :)

Dean
roehrich@cray.com


#! /bin/sh
# This is a shell archive.  Remove anything before this line, then unpack
# it by saving it into a file and typing "sh file". 
# Note:  This script will NOT overwrite any existing files.
# If this archive is complete, you will see the following message at the end:
#		"End of shell archive."
#
# Contents:
#   Eroot.pm Template.pm ex.pl
#
# Wrapped by roehrich@cray.com on Mon Nov 21 18:08:39 1994
#
PATH=/bin:/usr/bin:/usr/ucb ; export PATH
if test -f Eroot.pm -a "${1}" != "-c" ; then 
  echo shar: Will not over-write existing file \"Eroot.pm\"
else
echo shar: Extracting \"Eroot.pm\" \(13826 characters\)
sed "s/^X//" >Eroot.pm <<'END_OF_Eroot.pm'
X'di ';
X'ds 00 \"';
X'ig 00 ';
X#
X# Eternal Root: an exercise in object persistence.
X#   21nov94
X#   Dean Roehrich <roehrich@cray.com>
X#
X# changes/bugs fixed since 31oct94 version:
X#  - Moved to Class::Eroot.  Package is still EROOT.
X#  - Using Class::Template.pm (was Class.pm).
X# changes/bugs fixed since 20feb94 version:
X#  - Changed SLEEP/WAKEUP to suspend/resume.
X#  - Added Carp to some places.
X#  - Order of keep/resume is now preserved.
X#  - Keep is now more careful about taking blessed objects.
X#  - Store will no longer make up a class name for an unblessed object.
X#  - Convert to proper module.
X#  - Bug in WriteStack prevented first object on stack from getting a resume.
X#  - Replaced local() with my().
X#  - Resume can now bless to a lowercase class name without causing warnings.
X#  - Flattened EROOT::private class, it prevented reusability.
X#  - Continue now uses dynamic dispatch for Resume.
X#  - Updated manpage and examples.
X#  - Now using dynamic dispatch everywhere; eases reusability.
X#
X#	require Class::Eroot;
X#	my $some_obj;
X#	my $eroot = new EROOT ( 'Name' => "persist.file",
X#				   'Key'  => "myAppObjects" );
X#
X#	if( $eroot->Continue ){
X#		# No existing objects.  Start from scratch.
X#		$some_obj = new SomeObj;
X#		$eroot->Keep( "Some_obj" => $some_obj );
X#	}
X#	else{
X#		$some_obj = $eroot->Root("some_obj");
X#	}
X#
X#	$eroot->List;
X#	$eroot->Keep( "MyObj" => $myobj );
X#	$eroot->Lose( "Old_Obj" );
X#	$eroot->Lose( $this_obj );
X#
X# Feed to "nroff -man" for manpage.
X#
Xrequire 5.000;
Xpackage EROOT;
X@ISA=qw(Persister);
Xuse Carp;
Xuse Class::Template;
X
XVar: {
X
X	# Stub.  WriteStack will create method EROOT::Continue
X	# to override this.
X	sub Persister::Continue { 1; }
X	
X	$DumpStack = 0;
X	$WriteStack = 1;
X
X	members EROOT {
X		'refs'		=> '@',  # objects
X		'xrefs'		=> '%',  # indices into refs
X		'xnames'	=> '%',  # indices into xrefs
X		'id2name'	=> '%',  # indices into xnames
X		'fname'		=> '$',
X		'key'		=> '$',
X	};
X}
X
X
X# Parameters:  Name, Key
Xsub new {
X	my( $type, %args ) = @_;
X	my $self = InitMembers();
X
X	$self->fname( $args{'Name'} ) ||
X		croak "Need name of file for persistent objects";
X	$self->key( $args{'Key'} ) ||
X		croak "Need key for persistent objects";
X	require $args{'Name'} if( -e $args{'Name'} );
X	bless $self;
X}
X
X
XDESTROY {
X	my $self = shift;
X
X	$self->Store;
X}
X
X
Xsub Keep {
X	my $self = shift;
X	my( $name, $ref ) = @_;
X	my $i = @{$self->refs};
X	my $id;
X
X	if( @_ != 2 ){
X		carp "usage - EROOT::Keep( self, name, ref )";
X		return;
X	}
X	if( ! defined( ref $ref ) ){
X		carp "Not an object";
X	}
X	elsif(	"$ref" !~ /^([^=]+)=/o ){
X		carp "Not a blessed object";
X	}
X	else{
X		$self->refs( $i, $ref );
X		($id) = "$ref" =~ /\((0x[a-f0-9]+)\)$/o;
X		$self->xrefs( $id, $i );
X		$self->xnames( $name, $id );
X		$self->id2name( $id, $name );
X	}
X}
X
X
Xsub Lose {
X	my( $self, $ref ) = @_;
X	my( $id, $i );
X
X	if( defined( ref $ref ) ){
X		($id) = "$ref" =~ /\((0x[a-f0-9]+)\)$/o;
X		if( defined $self->xrefs($id) ){
X			$i = $self->xrefs($id);
X			$self->refs( $i, undef );
X			$self->xrefs( $id, undef );
X			$self->id2name( $id, undef );
X		}
X	}
X	elsif( defined $self->xnames( $ref ) ){
X		$id = $self->xnames( $ref );
X		$i = $self->xrefs( $id );
X		$self->refs( $i, undef );
X		$self->xrefs( $id, undef );
X		$self->id2name( $id, undef );
X	}
X	else{
X		carp "Not an object";
X	}
X}
X
X
Xsub Root {
X	my( $self, $name ) = @_;
X	my( $id, $i );
X	my $root = undef;
X
X	if( defined $self->xnames( $name ) ){
X		$id = $self->xnames( $name );
X		$i = $self->xrefs( $id );
X		$root = $self->refs( $i );
X	}
X	else{
X		carp "No root named $name";
X	}
X	$root;
X}
X
X
Xsub List {
X	my $self = shift;
X	my @keys = keys %{$self->xrefs};
X	my( $id, $i );
X
X	while( @keys ){
X		$id = shift @keys;
X		$i = $self->xrefs( $id );
X		print $self->id2name($id)," is ",$self->refs($i),"\n";
X	}
X}
X
X
X#
X# Private routines for the EROOT.  These actually do the store/restore
X# of the objects.
X#
X
X## private
Xsub Resume {
X	# Bless the reference in its own package.
X	eval qq{ bless \$_[2], qq{$_[1]} };
X	if( $@ ){
X		warn "While blessing ref $_[2] in class $_[1]: $@";
X	}
X	else{
X		# Let object resume.
X		eval { $_[2]->resume };
X	}
X}
X
X
X# Push all objects onto a stack, using breadth-first search.  The root
X# object is at the bottom of the stack, the leaf objects are at the top
X# of the stack.
X#
X
X## private
Xsub Store {
X	my $self = shift;
X	my $name = $self->{'fname'};
X	my( $n, $obj, @k );
X	my @s = ();
X	my @objs = @{$self->{'refs'}};
X	my $roots = $self->{'xrefs'};
X	my $id2name = $self->{'id2name'};
X	my $key = $self->{'key'};
X	my( $class, $type, $ident );
X	my %id = ();
X
X	while( @objs ){
X		$obj = shift @objs;
X		next if( ! defined $obj );
X		$class = "";
X		"$obj" =~ /^([^=]+)=/o && do { $class = $1 };
X		if( "$obj" =~ /([A-Z]+)\((0x[a-f0-9]+)\)$/o ){
X			($type,$ident) = ($1,$2);
X			next if( defined $id{$ident} );
X			$id{$ident}++;
X			push( @s, "end $ident" );
X
X			# Suspend the object.
X			eval { $obj->suspend } if( $class ne '' );
X
X			if( $type eq 'ARRAY' ){
X				if( @$obj ){
X					$self->StoreArray( $obj, $ident, \@s, \@objs );
X				}
X			}
X			elsif( $type eq 'HASH' ){
X				if( keys %$obj ){
X					$self->StoreHash( $obj, $ident, \@s, \@objs );
X				}
X			}
X			# The following also catches anything
X			# you thought was REF (REF is actually SCALAR^2).
X			elsif( $type eq 'SCALAR' ){
X				$self->StoreScalar( $obj, $ident, \@s, \@objs );
X			}
X			else{
X				die "Don't know how to handle $type $obj";
X			}
X			if( defined $roots->{$ident} ){
X				$n = $id2name->{$ident};
X				push( @s, "root $ident $n" );
X				$roots->{$ident} = undef;
X			}
X			push( @s, "object $ident $type $class" );
X		}
X		else{
X			warn "Unable to recognize object: $obj";
X		}
X	}
X	$self->DumpStack( \@s )			if $DumpStack;
X	$self->WriteStack( $key, $name, \@s )	if $WriteStack;
X}
X
X
X# Turn the stack into perl code.
X# This will create a method named Continue in the EROOT class.
X# This assumes that keys and values for the "objects" can be safely
X# represented as text within single quotes.
X#
X
X## private
Xsub WriteStack {
X	my $self = shift;
X	my( $key, $name, $s ) = @_;
X	my $fh = (caller)[0] . "::$name";
X	my $i = @$s;
X	my( $type, @v );
X	my( $junk, $word, $ident, $stuff );
X	my @roots = ();
X	my @keep = ();
X	my @keepwake = ();
X	my @wake = ();
X	my %wake = ();
X	my( $e1, $e2, $elem, $whack );
X	my @delayed = ();
X
X	open( $fh, ">$name" ) || do{
X		warn "Cannot save objects, unable to write to file $name";
X		return;
X	};
X	print $fh "#KEY:$key\n";
X	print $fh "# Persistent objects\n";
X	print $fh "sub EROOT::Continue {\n";
X	print $fh "  my \$self = shift;\n";
X	print $fh "  my \%ref = ();\n";
X	print $fh "  die \"These persistent objects (key=$key) do not belong to this application.\\n\"\n";
X	print $fh "    if( \$self->{\'key\'} ne \'$key\' );\n";
X	while( $i-- > 0 ){
X		($junk, $word, $ident, $stuff) =
X			split( /^(\w+) ([^\s]+) ?/o, $s->[$i], 2 );
X		if( $word eq 'object' ){
X			@v = split( ' ', $stuff );
X			$e1 = $e2 = $type = $whack = '';
X			if( $v[0] eq 'ARRAY' ){
X				$e1 = "[";
X				$e2 = "]";
X				$type = " = []";
X			}
X			elsif( $v[0] eq 'HASH' ){
X				$e1 = "{\'";
X				$e2 = "\'}";
X				$type = " = {}";
X			}
X			elsif( $v[0] eq 'SCALAR' ){
X				$whack = "\\";
X			}
X			if( defined $v[1] ){
X				push( @wake, "$ident!\$self->Resume( \'$v[1]\', \$ref{\'$ident\'} );" );
X				$wake{$ident} = $#wake;
X			}
X			print $fh "  {\n    my \$x$type;\n";
X		}
X		elsif( $word eq 'root' ){
X			push( @keep, "\$self->Keep( \'$stuff\', \$ref{\'$ident\'} );" );
X			push( @keepwake, "\$self->Resume( \'$v[1]\', \$ref{\'$ident\'} );" );
X			delete $wake{$ident};
X		}
X		elsif( $word eq 'end' ){
X			print $fh "    \$ref{\'$ident\'} = $whack\$x;\n  }\n";
X		}
X		elsif( $word eq 'ref' ){
X			($junk, @v) = split( /^\(([^)]*)\) /o, $stuff, 0 );
X			$elem = ($v[0] ne '') ? "->$e1$v[0]$e2" : "";
X			push( @delayed, "  \$ref{\'$ident\'}$elem = $whack\$ref{\'$v[1]\'};" );
X		}
X		elsif( $word eq 'simple' ){
X			($junk, @v) = split( /^\(([^)]*)\) /o, $stuff, 0 );
X			$v[1] = '' unless defined $v[1];
X			$elem = ($v[0] ne '') ? "->$e1$v[0]$e2" : "";
X			$v[1] =~ s/\'/\\\'/og; # save embedded single quotes
X			print $fh "    \$x$elem = \'$v[1]\';\n";
X		}
X		else{
X			warn "Unknown code: $v";
X		}
X	}
X	print $fh join("\n", @delayed),"\n";
X	# Everything here is to preserve Keep() and resume() order.
X	while( @wake ){
X		$_ = shift @wake;
X		@_ = split('!');
X		next unless defined $wake{$_[0]};
X		print $fh "  $_[1]\n";
X	}
X	print $fh "  ", join("\n  ", reverse @keepwake), "\n";
X	print $fh "  ", join("\n  ", reverse @keep), "\n";
X	print $fh "  0;\n}\n1;\n";
X	close( $fh );
X}
X
X## private
Xsub StoreScalar {
X	my $self = shift;
X	my( $obj, $ident, $s, $objs ) = @_;
X	my $v;
X
X	if( defined( ref $$obj ) ){
X		($v) = "$$obj" =~ /\((0x[a-f0-9]+)\)$/o;
X		push( @$s, "ref $ident () $v" );
X		push( @$objs, $$obj );
X	}
X	else{
X		push( @$s, "simple $ident () $$obj" );
X	}
X}
X
X## private
Xsub StoreHash {
X	my $self = shift;
X	my( $obj, $ident, $s, $objs ) = @_;
X	my( $k, $v, @k );
X
X	@k = keys %$obj;
X	while( @k ){
X		$k = shift @k;
X		if( defined $obj->{$k} ){
X			if( ! defined( ref $obj->{$k} ) ){
X				push( @$s, "simple $ident ($k) $obj->{$k}" );
X			}
X			else{
X				($v) = "$obj->{$k}" =~ /\((0x[a-f0-9]+)\)$/o;
X				push( @$s, "ref $ident ($k) $v" );
X				push( @$objs, $obj->{$k} );
X			}
X		}
X
X	}
X}
X
X## private
Xsub StoreArray {
X	my $self = shift;
X	my( $obj, $ident, $s, $objs ) = @_;
X	my $k = 0;
X	my $v;
X
X	while( $k < @$obj ){
X		if( defined $obj->[$k] ){
X			if( ! defined( ref $obj->[$k] ) ){
X				push( @$s, "simple $ident ($k) $obj->[$k]" );
X			}
X			else{
X				($v) = "$obj->[$k]" =~ /\((0x[a-f0-9]+)\)$/o;
X				push( @$s, "ref $ident ($k) $v" );
X				push( @$objs, $obj->[$k] );
X			}
X		}
X		++$k;
X	}
X	$k;
X}
X
X## private
Xsub DumpStack {
X	my $self = shift;
X	my( $s ) = shift;
X	my $i = @$s;
X
X	while( $i-- > 0 ){
X		print "$s->[$i]\n";
X	}
X}
X
X#########################################################################
X
X	# These next few lines are legal in both Perl and nroff.
X
X.00;			# finish .ig
X
X'di			\" finish diversion--previous line must be blank
X.nr nl 0-1		\" fake up transition to first page again
X.nr % 0			\" start at page 1
X'; 1;__END__ ############# From here on it's a standard manual page #######
X.nh	\" do not hyphenate
X.TH EROOT PERL "September 3, 1994"
X.AT 3
X.SH NAME
XEroot \- an eternal root to handle persistent objects
X.SH ABSTRACT
XThe Eternal Root
X.I (eroot)
Xis given references to the root objects
Xof any object hierarchies which must persist between separate invocations of
Xthe application.  When the eroot's destructor is called, the eroot will find
Xall objects referenced in the object hierarchies and will store them.
XAll objects will be restored (if possible) when and if the
X.I Continue
Xmessage is sent to the eroot.
X.SH SYNOPSIS
X.nf
X	require Class::Eroot;
X	my $some_obj;
X	my $eroot = new EROOT ( 'Name' => "persist.file",
X						  'Key'  => "myAppObjects" );
X
X	if( $eroot->Continue ){
X		# No existing objects.  Start from scratch.
X		$some_obj = new SomeObj;
X		$eroot->Keep( "Some_obj" => $some_obj );
X	}
X	else{
X		$some_obj = $eroot->Root("some_obj");
X	}
X
X	$eroot->List;
X	$eroot->Keep( "MyObj" => $myobj );
X	$eroot->Lose( "Old_Obj" );
X	$eroot->Lose( $this_obj );
X.fi
X.SH DESCRIPTION
XWhen the eroot saves a group of object hierarchies, it stores its
X.I key
Xwith
Xthem.  The key of any objects being restored must match the key of the eroot
Xwhich is trying to restore them.  The
X.I Continue
Xmethod will call
X.I die
Xif the keys do not match.  Continue will return 0 if
Xthe objects were loaded and non-zero if they were not.
X.PP
XThe eroot will attempt to send a
X.I suspend
Xmessage to the object prior to
Xstoring the object's state.  The object's class is not required to have a
Xsuspend method defined.
X.PP
XWhen the eroot restores an object it will bless the object reference in the
Xobject's class (package) and will attempt to send a
X.I resume
Xmessage to the
Xobject.  The object's class is not required to have a resume method defined.
X.PP
XAn object should not propagate
X.I suspend
Xand
X.I resume
Xmessages.  The eroot will
Xsend suspend messages to the objects in the order in which they were stored in
Xthe eroot (breadth-first, root-to-leaves).  The eroot will send resume
Xmessages by starting with the classes of the objects at the leaves of the
Xobject hierarchy and moving toward the root of the object hierarchy.
X.PP
XNote that Perl will call the
X.I destructors
Xof the persistent objects.  The programmer should be prepared to deal with
Xthis.
X.PP
XIt is necessary to
X.I Keep
Xan object only once.  The object will remain
Xpersistent until the eroot is
Xtold to
X.I Lose
Xit.
X.SH INSTANCE VARIABLES
XReferences will be properly hooked
Xup if they are type SCALAR, ARRAY, REF, or HASH.
XThe eroot assumes that keys and values (if the value is not a
Xreference) for the objects'
X.I instance variables
Xcan be represented as text within 
Xsingle quotes.  If this is not true for your objects then the object's
X.I suspend
Xmethod can be used to "wrap" the object for storage, and the
X.I resume
Xmethod can be used to "unwrap" the object.
X.PP
XEmbedded single quotes in the value will be preserved.  This is
Xcurrently the only place where single quotes are handled.
X.SH THINGS TO AVOID
X.nf
X	o Storing the eroot.
X	o Storing references to tie()'d variables and objects.
X	o Storing references to CODE objects.
X	o Storing the same object in two different eroots.
X	  Unless you think you know what you're doing, of course.
X	o Using two eroots to store each other :)
X	o Storing named arrays and hashes.  These will be restored as
X	  anonymous arrays and hashes.
X	o Storing an object while it has an open stream.
X	o Storing an object which has an %OVERLOAD somewhere in
X	  it's class hierarchy.
X.fi
X.PP
XKnow your object hierarchy.  Be sure that everything in the hierarchy
Xcan handle persistence.
X.SH NOTES
XThis is not an OODBMS.
X.SH FILES
XEroot.pm		\- Eternal Root class.
X.br
Xpersist.file	\- User\-defined file where objects are stored.
X.br
XClass.pm		\- Struct/member template builder.
X.ex
END_OF_Eroot.pm
if test 13826 -ne `wc -c <Eroot.pm`; then
    echo shar: \"Eroot.pm\" unpacked with wrong size!
fi
# end of overwriting check
fi
if test -f Template.pm -a "${1}" != "-c" ; then 
  echo shar: Will not over-write existing file \"Template.pm\"
else
echo shar: Extracting \"Template.pm\" \(4926 characters\)
sed "s/^X//" >Template.pm <<'END_OF_Template.pm'
Xpackage Class::Template;
Xrequire 5.000;
Xrequire Exporter;
X
X@ISA = qw(Exporter);
X@EXPORT = qw(members struct);
Xuse strict;
X
X# Template.pm   --- struct/member template builder
X#   02sep94
X#   Dean Roehrich <roehrich@cray.com>
X#
X# changes/bugs fixed since 02sep94 version:
X#  - Moved to Class::Template.
X# changes/bugs fixed since 20feb94 version:
X#  - Updated to be a more proper module.
X#  - Added "use strict".
X#  - Bug in build_methods, was using @var when @$var needed.
X#  - Now using my() rather than local().
X#
X# Uses perl5 classes to create nested data types.
X# This is offered as one implementation of Tom Christiansen's "structs.pl"
X# idea.
X#
X# Example 1:
X# 
X#	use Class::Template;
X#	Class::Template::printem();
X#	
X#	struct( rusage => {
X#		ru_utime => timeval,
X#		ru_stime => timeval,
X#	});
X#	
X#	struct( timeval => [
X#		tv_secs  => '$',
X#		tv_usecs => '$',
X#	]);
X#
X#	my $s = new rusage;
X#
X# Example 2:
X#
X#	package OBJ;
X#	use Class::Template;
X#	Class::Template::printem();
X#
X#	members OBJ {
X#		'a'	=> '$',
X#		'b'	=> '$',
X#	};
X#
X#	members OBJ2 {
X#		'd'	=> '@',
X#		'c'	=> '$',
X#	};
X#
X#	package OBJ2; @ISA = (OBJ);
X#
X#	sub new {
X#		my $r = InitMembers( &OBJ::InitMembers() );
X#		bless $r;
X#	}
X#
X# 
X# Use '%' if the member should point to an anonymous hash.
X# Use '@' if the member should point to an anonymous array.
X#
X# When using % and @ the method requires one argument for the key or
X# index into the hash or array.
X#
X# Prefix the %, @, or $ with '*' to indicate you want to retrieve
X# pointers to the values rather than the values themselves.
X#
X
XVar: {
X	$Class::Template::print = 0;
X	sub printem { $Class::Template::print++ }
X}
X
X
Xsub struct {
X	my( $struct, $ref ) = @_;
X	my @methods = ();
X	my %refs = ();
X	my %arrays = ();
X	my %hashes = ();
X	my $out = '';
X
X	$out = "{\n  package $struct;\n  sub new {\n";
X	parse_fields( $ref, \$out, \@methods, \%refs, \%arrays, \%hashes, 0 );
X	$out .= "      bless \$r;\n  }\n";
X	build_methods( $ref, \$out, \@methods, \%refs, \%arrays, \%hashes );
X	$out .= "}\n1;\n";
X
X	( $Class::Template::print ) ? print( $out ) : eval $out;
X}
X
Xsub members {
X	my( $pkg, $ref ) = @_;
X	my @methods = ();
X	my %refs = ();
X	my %arrays = ();
X	my %hashes = ();
X	my $out = '';
X
X	$out = "{\n  package $pkg;\n  sub InitMembers {\n";
X	parse_fields( $ref, \$out, \@methods, \%refs, \%arrays, \%hashes, 1 );
X	$out .= "      bless \$r;\n  }\n";
X	build_methods( $ref, \$out, \@methods, \%refs, \%arrays, \%hashes );
X	$out .= "}\n1;\n";
X
X	( $Class::Template::print ) ? print( $out ) : eval $out;
X}
X
X
Xsub parse_fields {
X	my( $ref, $out, $methods, $refs, $arrays, $hashes, $member ) = @_;
X	my $type = ref $ref;
X	my @keys;
X	my $val;
X	my $cnt = 0;
X	my $idx = 0;
X	my( $cmt, $n );
X
X	if( $type eq 'HASH' ){
X		if( $member ){
X			$$out .= "      my(\$r) = \@_ ? shift : {};\n";
X		}
X		else{
X			$$out .= "      my(\$r) = {};\n";
X		}
X		@keys = keys %$ref;
X		foreach (@keys){
X			$val = $ref->{$_};
X			if( $val =~ /^\*(.)/ ){
X				$refs->{$_}++;
X				$val = $1;
X			}
X			if( $val eq '@' ){
X				$$out .= "      \$r->{'$_'} = [];\n";
X				$arrays->{$_}++;
X			}
X			elsif( $val eq '%' ){
X				$$out .= "      \$r->{'$_'} = {};\n";
X				$hashes->{$_}++;
X			}
X			elsif( $val ne '$' ){
X				$$out .= "      \$r->{'$_'} = \&${val}::new();\n";
X			}
X			else{
X				$$out .= "      \$r->{'$_'} = undef;\n";
X			}
X			push( @$methods, $_ );
X		}
X	}
X	elsif( $type eq 'ARRAY' ){
X		if( $member ){
X			$$out .= "      my(\$r) = \@_ ? shift : [];\n";
X		}
X		else{
X			$$out .= "      my(\$r) = [];\n";
X		}
X		while( $idx < @$ref ){
X			$n = $ref->[$idx];
X			push( @$methods, $n );
X			$val = $ref->[$idx+1];
X			$cmt = "# $n";
X			if( $val =~ /^\*(.)/ ){
X				$refs->{$n}++;
X				$val = $1;
X			}
X			if( $val eq '@' ){
X				$$out .= "      \$r->[$cnt] = []; $cmt\n";
X				$arrays->{$n}++;
X			}
X			elsif( $val eq '%' ){
X				$$out .= "      \$r->[$cnt] = {}; $cmt\n";
X				$hashes->{$n}++;
X			}
X			elsif( $val ne '$' ){
X				$$out .= "      \$r->[$cnt] = \&${val}::new();\n";
X			}
X			else{
X				$$out .= "      \$r->[$cnt] = undef; $cmt\n";
X			}
X			++$cnt;
X			$idx += 2;
X		}
X	}
X}
X
X
Xsub build_methods {
X	my( $ref, $out, $methods, $refs, $arrays, $hashes ) = @_;
X	my $type = ref $ref;
X	my $elem = '';
X	my $cnt = 0;
X	my( $pre, $pst, $cmt, $idx );
X
X	foreach (@$methods){
X		$pre = $pst = $cmt = $idx = '';
X		if( defined $refs->{$_} ){
X			$pre = "\\(";
X			$pst = ")";
X			$cmt = " # returns ref";
X		}
X		$$out .= "  sub $_ {$cmt\n      my \$r = shift;\n";
X		if( $type eq 'ARRAY' ){
X			$elem = "[$cnt]";
X			++$cnt;
X		}
X		elsif( $type eq 'HASH' ){
X			$elem = "{'$_'}";
X		}
X		if( defined $arrays->{$_} ){
X			$$out .= "      my \$i;\n";
X			$$out .= "      \@_ ? (\$i = shift) : return \$r->$elem;\n";
X			$idx = "->[\$i]";
X		}
X		elsif( defined $hashes->{$_} ){
X			$$out .= "      my \$i;\n";
X			$$out .= "      \@_ ? (\$i = shift) : return \$r->$elem;\n";
X			$idx = "->{\$i}";
X		}
X		$$out .= "      \@_ ? (\$r->$elem$idx = shift) : $pre\$r->$elem$idx$pst;\n";
X		$$out .= "  }\n";
X	}
X}
X
X1;
END_OF_Template.pm
if test 4926 -ne `wc -c <Template.pm`; then
    echo shar: \"Template.pm\" unpacked with wrong size!
fi
# end of overwriting check
fi
if test -f ex.pl -a "${1}" != "-c" ; then 
  echo shar: Will not over-write existing file \"ex.pl\"
else
echo shar: Extracting \"ex.pl\" \(309 characters\)
sed "s/^X//" >ex.pl <<'END_OF_ex.pl'
Xrequire Class::Eroot;
X
X
X{ package OBJ;
X	sub new {
X		local $x = 0;
X		bless \$x;
X	}
X}
X
X
Xlocal $a;
Xlocal $eroot = new EROOT ( 'Name' => "/tmp/test", 'Key' => 'myApp' );
X
Xif( $eroot->Continue ){
X	$a = new OBJ;
X	$eroot->Keep( "myObj" => $a );
X}
Xelse {
X	$a = $eroot->Root( "myObj" );
X}
X
X
Xprint "a=$$a\n";
X++$$a;
X1;
END_OF_ex.pl
if test 309 -ne `wc -c <ex.pl`; then
    echo shar: \"ex.pl\" unpacked with wrong size!
fi
# end of overwriting check
fi
echo shar: End of shell archive.
exit 0


