# -*- cperl -*-
# ABSTRACT: LaTeX operator object


package SpeL::Object::Binop;


use parent 'Exporter';
use Carp;

use Data::Dumper;



sub read {
  my $self = shift;
  my ( $level ) = @_;

  # say STDERR Data::Dumper->Dump( [ $self ], [ 'self' ] );
  if ( exists $self->{Op} ) {
    $self->{Op} =~ /^[+-]$/ and
      return ' ' . $SpeL::I18n::lh->maketext( $self->{Op} ) . ' ';
    $self->{Op} =~ /^\\pm$/ and
      return ' ' . $SpeL::I18n::lh->maketext( 'plusminus' ) . ' ';
    $self->{Op} =~ /^,|;$/ and
      return ', ';
    $self->{Op} =~ /^\\in$/ and
      return ' ' . $SpeL::I18n::lh->maketext( 'In' ) . ' ';
    $self->{Op} =~ /^\\mid$/ and
      return ' ' . $SpeL::I18n::lh->maketext( 'Mid' ) . ' ';
    $self->{Op} =~ /^\\times|\\cdot$/ and
      return ' ' . $SpeL::I18n::lh->maketext( '*' ) . ' ';
    return ' ' . $SpeL::I18n::lh->maketext( '*' ) . ' ';
  }
  if ( exists $self->{Pause} ) {
    return ', ';
  }
  if ( exists $self->{Com} ) {
    return $self->{Com}->read( $level + 1 );
  }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Binop - LaTeX operator object

=head1 VERSION

version 20240619.1055

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX operator

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
