/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.ber;

import com.vizdom.ber.BerIdentifier;
import com.vizdom.ber.BerModule;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BerObject {
    static int gReadLength(InputStream anIn) throws IOException {
        int octet = anIn.read();
        if (octet == -1) {
            throw new EOFException();
        }
        if (octet <= 127) {
            return octet;
        }
        int count = octet & 0x7F;
        int length = 0;
        for (int i = 0; i < count; ++i) {
            octet = anIn.read();
            if (octet == -1) {
                throw new EOFException();
            }
            length = length << 8 | octet;
        }
        return length;
    }

    private static void gWriteLength(int aLength, OutputStream anOut) throws IOException {
        if (aLength <= 127) {
            anOut.write(aLength);
        } else {
            int count = 0;
            for (int l = aLength; l != 0; l >>>= 8) {
                ++count;
            }
            anOut.write(0x80 | count);
            int mask = 255 << (count - 1) * 8;
            for (int i = count * 8; i > 0; i -= 8) {
                int octet = (aLength & mask) >>> i - 8;
                anOut.write(octet);
                mask >>>= 8;
            }
        }
    }

    public final void writeTo(OutputStream anOut) throws IOException {
        this.getIdentifier().mWrite(anOut);
        BerObject.gWriteLength(this.mGetLength(), anOut);
        this.mWriteContents(anOut);
    }

    protected abstract int mGetLength();

    protected abstract void mWriteContents(OutputStream var1) throws IOException;

    protected abstract void mReadContents(InputStream var1, BerModule var2, BerIdentifier var3, int var4) throws IOException;

    public abstract BerIdentifier getIdentifier();

    public abstract String toString();
}

