########################################
use strict;
use warnings;
use IO::Scalar;
use Test::More tests => 4;
########################################
our $class;
BEGIN {
    $class = 'D64::Disk::Layout::Sector';
    use_ok($class);
}
########################################
our $sector_data_size = eval "\$${class}::SECTOR_DATA_SIZE";
########################################
sub get_chained_sector_data {
    my @data = map { chr 0x00 } (0x01 .. $sector_data_size);
    my @file = map { chr } map { hex } qw(11 06 00 10);
    splice @data, 0, scalar (@file), @file;
    return @data;
}
########################################
sub get_last_sector_data {
    my @data = map { chr 0x00 } (0x01 .. $sector_data_size);
    my @file = map { chr } map { hex } qw(00 04 00 10 60);
    splice @data, 0, scalar (@file), @file;
    return @data;
}
########################################
sub get_chained_sector_object {
    my @data = get_chained_sector_data();
    my $track = 0x11;
    my $sector = 0x03;
    my $object = $class->new(data => \@data, track => $track, sector => $sector);
    return $object;
}
########################################
sub get_last_sector_object {
    my @data = get_last_sector_data();
    my $track = 0x13;
    my $sector = 0x01;
    my $object = $class->new(data => \@data, track => $track, sector => $sector);
    return $object;
}
########################################
{
    my $object = $class->new();
    my $sh = new IO::Scalar;
    $object->print(fh => $sh);
    my $print_out = ${$sh->sref};
    my $expected_print_out = <<'    PRINT';
    00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 
    -----------------------------------------------
00: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
10: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
20: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
30: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
40: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
50: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
60: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
70: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
80: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
90: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
    PRINT
    is($print_out, $expected_print_out, 'print out sector data for an empty sector object');
}
########################################
{
    my $object = get_chained_sector_object();
    my $sh = new IO::Scalar;
    $object->print(fh => $sh);
    my $print_out = ${$sh->sref};
    my $expected_print_out = <<'    PRINT';
    00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 
    -----------------------------------------------
00: 11 06 00 10 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
10: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
20: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
30: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
40: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
50: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
60: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
70: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
80: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
90: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
    PRINT
    is($print_out, $expected_print_out, 'print out sector data for a chained sector object');
}
########################################
{
    my $object = get_last_sector_object();
    my $sh = new IO::Scalar;
    $object->print(fh => $sh);
    my $print_out = ${$sh->sref};
    my $expected_print_out = <<'    PRINT';
    00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 
    -----------------------------------------------
00: 00 04 00 10 60 00 00 00 00 00 00 00 00 00 00 00 ????`???????????
10: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
20: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
30: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
40: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
50: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
60: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
70: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
80: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
90: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ????????????????
    PRINT
    is($print_out, $expected_print_out, 'print out sector data for a last sector object');
}
########################################
