=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsAutoFilterApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_auto_filter_delete_worksheet_date_filter
#
# Removes a date filter.             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $field_index  (required)
# @param string $date_time_grouping_type  (required)
# @param int $year  (optional, default to 0)
# @param int $month  (optional, default to 0)
# @param int $day  (optional, default to 0)
# @param int $hour  (optional, default to 0)
# @param int $minute  (optional, default to 0)
# @param int $second  (optional, default to 0)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'date_time_grouping_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'year' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'month' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'day' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'hour' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'minute' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'second' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_delete_worksheet_date_filter' } = { 
    	summary => 'Removes a date filter.             ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_auto_filter_delete_worksheet_date_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_delete_worksheet_date_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_delete_worksheet_date_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_delete_worksheet_date_filter");
    }

    # verify the required parameter 'date_time_grouping_type' is set
    unless (exists $args{'date_time_grouping_type'}) {
      croak("Missing the required parameter 'date_time_grouping_type' when calling cells_auto_filter_delete_worksheet_date_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/dateFilter';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'date_time_grouping_type'}) {
        $query_params->{'dateTimeGroupingType'} = $self->{api_client}->to_query_value($args{'date_time_grouping_type'});
    }

    # query params
    if ( exists $args{'year'}) {
        $query_params->{'year'} = $self->{api_client}->to_query_value($args{'year'});
    }

    # query params
    if ( exists $args{'month'}) {
        $query_params->{'month'} = $self->{api_client}->to_query_value($args{'month'});
    }

    # query params
    if ( exists $args{'day'}) {
        $query_params->{'day'} = $self->{api_client}->to_query_value($args{'day'});
    }

    # query params
    if ( exists $args{'hour'}) {
        $query_params->{'hour'} = $self->{api_client}->to_query_value($args{'hour'});
    }

    # query params
    if ( exists $args{'minute'}) {
        $query_params->{'minute'} = $self->{api_client}->to_query_value($args{'minute'});
    }

    # query params
    if ( exists $args{'second'}) {
        $query_params->{'second'} = $self->{api_client}->to_query_value($args{'second'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_delete_worksheet_filter
#
# Delete a filter for a filter column.             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $field_index  (required)
# @param string $criteria  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'criteria' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_delete_worksheet_filter' } = { 
    	summary => 'Delete a filter for a filter column.             ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_auto_filter_delete_worksheet_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_delete_worksheet_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_delete_worksheet_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_delete_worksheet_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/filter';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'criteria'}) {
        $query_params->{'criteria'} = $self->{api_client}->to_query_value($args{'criteria'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_get_worksheet_auto_filter
#
# Get Auto filter Description
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_get_worksheet_auto_filter' } = { 
    	summary => 'Get Auto filter Description',
        params => $params,
        returns => 'AutoFilterResponse',
        };
}
# @return AutoFilterResponse
#
sub cells_auto_filter_get_worksheet_auto_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_get_worksheet_auto_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_get_worksheet_auto_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('AutoFilterResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_post_worksheet_auto_filter_refresh
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_post_worksheet_auto_filter_refresh' } = { 
    	summary => '',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_auto_filter_post_worksheet_auto_filter_refresh {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_post_worksheet_auto_filter_refresh");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_post_worksheet_auto_filter_refresh");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/refresh';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_post_worksheet_match_blanks
#
# Match all blank cell in the list.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $field_index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_post_worksheet_match_blanks' } = { 
    	summary => 'Match all blank cell in the list.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_auto_filter_post_worksheet_match_blanks {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_post_worksheet_match_blanks");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_post_worksheet_match_blanks");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_post_worksheet_match_blanks");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/matchBlanks';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_post_worksheet_match_non_blanks
#
# Match all not blank cell in the list.             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $field_index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_post_worksheet_match_non_blanks' } = { 
    	summary => 'Match all not blank cell in the list.             ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_auto_filter_post_worksheet_match_non_blanks {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_post_worksheet_match_non_blanks");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_post_worksheet_match_non_blanks");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_post_worksheet_match_non_blanks");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/matchNonBlanks';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_color_filter
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param ColorFilterRequest $color_filter  (optional)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'color_filter' => {
        data_type => 'ColorFilterRequest',
        description => '',
        required => '0',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_color_filter' } = { 
    	summary => '',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_auto_filter_put_worksheet_color_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_color_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_color_filter");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_color_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_color_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/colorFilter';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'color_filter'}) {
        $_body_data = $args{'color_filter'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_custom_filter
#
# Filters a list with a custom criteria.             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param string $operator_type1  (required)
# @param string $criteria1  (required)
# @param boolean $is_and  (optional)
# @param string $operator_type2  (optional)
# @param string $criteria2  (optional)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'operator_type1' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'criteria1' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'is_and' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'operator_type2' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'criteria2' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_custom_filter' } = { 
    	summary => 'Filters a list with a custom criteria.             ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_auto_filter_put_worksheet_custom_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_custom_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_custom_filter");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_custom_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_custom_filter");
    }

    # verify the required parameter 'operator_type1' is set
    unless (exists $args{'operator_type1'}) {
      croak("Missing the required parameter 'operator_type1' when calling cells_auto_filter_put_worksheet_custom_filter");
    }

    # verify the required parameter 'criteria1' is set
    unless (exists $args{'criteria1'}) {
      croak("Missing the required parameter 'criteria1' when calling cells_auto_filter_put_worksheet_custom_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/custom';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'operator_type1'}) {
        $query_params->{'operatorType1'} = $self->{api_client}->to_query_value($args{'operator_type1'});
    }

    # query params
    if ( exists $args{'criteria1'}) {
        $query_params->{'criteria1'} = $self->{api_client}->to_query_value($args{'criteria1'});
    }

    # query params
    if ( exists $args{'is_and'}) {
        $query_params->{'isAnd'} = $self->{api_client}->to_query_value($args{'is_and'});
    }

    # query params
    if ( exists $args{'operator_type2'}) {
        $query_params->{'operatorType2'} = $self->{api_client}->to_query_value($args{'operator_type2'});
    }

    # query params
    if ( exists $args{'criteria2'}) {
        $query_params->{'criteria2'} = $self->{api_client}->to_query_value($args{'criteria2'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_date_filter
#
# add date filter in worksheet 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param string $date_time_grouping_type  (required)
# @param int $year  (optional, default to 0)
# @param int $month  (optional, default to 0)
# @param int $day  (optional, default to 0)
# @param int $hour  (optional, default to 0)
# @param int $minute  (optional, default to 0)
# @param int $second  (optional, default to 0)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'date_time_grouping_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'year' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'month' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'day' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'hour' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'minute' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'second' => {
        data_type => 'int',
        description => '',
        required => '0',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_date_filter' } = { 
    	summary => 'add date filter in worksheet ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_auto_filter_put_worksheet_date_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_date_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_date_filter");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_date_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_date_filter");
    }

    # verify the required parameter 'date_time_grouping_type' is set
    unless (exists $args{'date_time_grouping_type'}) {
      croak("Missing the required parameter 'date_time_grouping_type' when calling cells_auto_filter_put_worksheet_date_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/dateFilter';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'date_time_grouping_type'}) {
        $query_params->{'dateTimeGroupingType'} = $self->{api_client}->to_query_value($args{'date_time_grouping_type'});
    }

    # query params
    if ( exists $args{'year'}) {
        $query_params->{'year'} = $self->{api_client}->to_query_value($args{'year'});
    }

    # query params
    if ( exists $args{'month'}) {
        $query_params->{'month'} = $self->{api_client}->to_query_value($args{'month'});
    }

    # query params
    if ( exists $args{'day'}) {
        $query_params->{'day'} = $self->{api_client}->to_query_value($args{'day'});
    }

    # query params
    if ( exists $args{'hour'}) {
        $query_params->{'hour'} = $self->{api_client}->to_query_value($args{'hour'});
    }

    # query params
    if ( exists $args{'minute'}) {
        $query_params->{'minute'} = $self->{api_client}->to_query_value($args{'minute'});
    }

    # query params
    if ( exists $args{'second'}) {
        $query_params->{'second'} = $self->{api_client}->to_query_value($args{'second'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_dynamic_filter
#
# 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param string $dynamic_filter_type  (required)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'dynamic_filter_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_dynamic_filter' } = { 
    	summary => '',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_auto_filter_put_worksheet_dynamic_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_dynamic_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_dynamic_filter");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_dynamic_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_dynamic_filter");
    }

    # verify the required parameter 'dynamic_filter_type' is set
    unless (exists $args{'dynamic_filter_type'}) {
      croak("Missing the required parameter 'dynamic_filter_type' when calling cells_auto_filter_put_worksheet_dynamic_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/dynamicFilter';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'dynamic_filter_type'}) {
        $query_params->{'dynamicFilterType'} = $self->{api_client}->to_query_value($args{'dynamic_filter_type'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_filter
#
# Adds a filter for a filter column.             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param string $criteria  (required)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'criteria' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_filter' } = { 
    	summary => 'Adds a filter for a filter column.             ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_auto_filter_put_worksheet_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_filter");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_filter");
    }

    # verify the required parameter 'criteria' is set
    unless (exists $args{'criteria'}) {
      croak("Missing the required parameter 'criteria' when calling cells_auto_filter_put_worksheet_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/filter';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'criteria'}) {
        $query_params->{'criteria'} = $self->{api_client}->to_query_value($args{'criteria'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_filter_top10
#
# Filter the top 10 item in the list
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param boolean $is_top  (required)
# @param boolean $is_percent  (required)
# @param int $item_count  (required)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'is_top' => {
        data_type => 'boolean',
        description => '',
        required => '1',
    },
    'is_percent' => {
        data_type => 'boolean',
        description => '',
        required => '1',
    },
    'item_count' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_filter_top10' } = { 
    	summary => 'Filter the top 10 item in the list',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_auto_filter_put_worksheet_filter_top10 {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # verify the required parameter 'is_top' is set
    unless (exists $args{'is_top'}) {
      croak("Missing the required parameter 'is_top' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # verify the required parameter 'is_percent' is set
    unless (exists $args{'is_percent'}) {
      croak("Missing the required parameter 'is_percent' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # verify the required parameter 'item_count' is set
    unless (exists $args{'item_count'}) {
      croak("Missing the required parameter 'item_count' when calling cells_auto_filter_put_worksheet_filter_top10");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/filterTop10';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'is_top'}) {
        $query_params->{'isTop'} = $self->{api_client}->to_query_value($args{'is_top'});
    }

    # query params
    if ( exists $args{'is_percent'}) {
        $query_params->{'isPercent'} = $self->{api_client}->to_query_value($args{'is_percent'});
    }

    # query params
    if ( exists $args{'item_count'}) {
        $query_params->{'itemCount'} = $self->{api_client}->to_query_value($args{'item_count'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_auto_filter_put_worksheet_icon_filter
#
# Adds an icon filter.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $range  (required)
# @param int $field_index  (required)
# @param string $icon_set_type  (required)
# @param int $icon_id  (required)
# @param boolean $match_blanks  (optional)
# @param boolean $refresh  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'range' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'field_index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'icon_set_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'icon_id' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'match_blanks' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'refresh' => {
        data_type => 'boolean',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_auto_filter_put_worksheet_icon_filter' } = { 
    	summary => 'Adds an icon filter.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_auto_filter_put_worksheet_icon_filter {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_auto_filter_put_worksheet_icon_filter");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_auto_filter_put_worksheet_icon_filter");
    }

    # verify the required parameter 'range' is set
    unless (exists $args{'range'}) {
      croak("Missing the required parameter 'range' when calling cells_auto_filter_put_worksheet_icon_filter");
    }

    # verify the required parameter 'field_index' is set
    unless (exists $args{'field_index'}) {
      croak("Missing the required parameter 'field_index' when calling cells_auto_filter_put_worksheet_icon_filter");
    }

    # verify the required parameter 'icon_set_type' is set
    unless (exists $args{'icon_set_type'}) {
      croak("Missing the required parameter 'icon_set_type' when calling cells_auto_filter_put_worksheet_icon_filter");
    }

    # verify the required parameter 'icon_id' is set
    unless (exists $args{'icon_id'}) {
      croak("Missing the required parameter 'icon_id' when calling cells_auto_filter_put_worksheet_icon_filter");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/autoFilter/iconFilter';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'range'}) {
        $query_params->{'range'} = $self->{api_client}->to_query_value($args{'range'});
    }

    # query params
    if ( exists $args{'field_index'}) {
        $query_params->{'fieldIndex'} = $self->{api_client}->to_query_value($args{'field_index'});
    }

    # query params
    if ( exists $args{'icon_set_type'}) {
        $query_params->{'iconSetType'} = $self->{api_client}->to_query_value($args{'icon_set_type'});
    }

    # query params
    if ( exists $args{'icon_id'}) {
        $query_params->{'iconId'} = $self->{api_client}->to_query_value($args{'icon_id'});
    }

    # query params
    if ( exists $args{'match_blanks'}) {
        $query_params->{'matchBlanks'} = $self->{api_client}->to_query_value($args{'match_blanks'});
    }

    # query params
    if ( exists $args{'refresh'}) {
        $query_params->{'refresh'} = $self->{api_client}->to_query_value($args{'refresh'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

1;
