
#ifndef _string_h
#define _string_h 1

#include <stddef.h>


extern "C" {

char*     strcat(char*, const char*);
char*     strchr(const char*, int);
int       strcmp(const char*, const char*);
int       strcoll(const char*, const char*);
char*     strcpy(char*, const char*);
size_t    strcspn(const char*, const char*);
char*     strdup(const char*);
size_t    strlen(const char*);
char*     strncat(char*, const char*, size_t);
int       strncmp(const char*, const char*, size_t);
char*     strncpy(char*, const char*, size_t);
char*     strpbrk(const char*, const char*);
char*     strrchr(const char*, int);
size_t    strspn(const char*, const char*);
char*     strstr(const char*, const char *);
char*     strtok(char*, const char*);
size_t    strxfrm(char*, const char*, size_t);

}

#ifdef USG
inline char* index(const char* s, int c) { return strchr(s, c); }
inline char* rindex(const char* s, int c) { return strrchr(s, c); }

#else /* not USG */

extern "C" {
char*     index(const char*, int);
char*     rindex(const char*, int);
}

#endif

#include <memory.h>

#endif
