// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_POOMA_PARTICLES_H
#define POOMA_POOMA_PARTICLES_H

//-----------------------------------------------------------------------------
// A one-stop-shopping header file that sets up everything one needs to use
// all Pooma II particle objects and layouts.
//-----------------------------------------------------------------------------

// Include files for the basic particle base class

#include "Particles/Particles.h"

// Include file for DynamicArray, used for particle attributes:

#include "Pooma/DynamicArrays.h" 

// Include file for canned particles traits structs

#include "Particles/CommonParticleTraits.h"

// Include files for the particle layout classes

#include "Particles/SpatialLayout.h"
#include "Particles/UniformLayout.h"

// Include files for particle boundary conditions

#include "Particles/AbsorbBC.h"
#include "Particles/KillBC.h"
#include "Particles/PeriodicBC.h"
#include "Particles/ReflectBC.h"
#include "Particles/ReverseBC.h"

// Include files for particle/field interpolators

#include "Particles/InterpolatorNGP.h"
#include "Particles/InterpolatorCIC.h"
#include "Particles/InterpolatorSUDS.h"

#endif

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Particles.h,v $   $Author: swhaney $
// $Revision: 1.8 $   $Date: 2000/03/07 13:18:03 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
