// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// UniformGridPartition test
//-----------------------------------------------------------------------------


#include "Pooma/Pooma.h"
#include "Pooma/Domains.h"
#include "Layout/UniformGridLayout.h"
#include "Layout/GridLayout.h"
#include "Partition/UniformGridPartition.h"
#include "Utilities/Tester.h"


int main(int argc, char *argv[]) {
  int i;

  // Initialize POOMA and output stream, using Tester class
	
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);
  tester.out() << argv[0] << ": Partition operations." << std::endl;
  tester.out() << "---------------------------------------------" << std::endl;

  // Create a UniformGridLayout with a non-empty domain and a set of
  // blocks.

  Loc<2> blocks(2,3);
  Interval<2> domain(12, 12);
  tester.out() << "Creating UniformGridLayout with blocks=" << blocks;
  tester.out() << ", domain=" << domain << std::endl;
  UniformGridLayout<2> ugrid1(domain, blocks, ReplicatedTag());
  tester.out() << "Layout = " << ugrid1 << std::endl;
  tester.check(ugrid1.sizeLocal() == 6);

  // Create a GridLayout with an empty domain and the same set of blocks

  Interval<2> domain2;
  tester.out() << "Creating GridLayout with blocks=" << blocks;
  tester.out() << ", domain=" << domain2 << std::endl;
  GridLayout<2> grid2(domain2, blocks,ReplicatedTag());
  tester.out() << "Layout = " << grid2 << std::endl;
  tester.check(grid2.sizeLocal() == 6);
  for (i=0; i < grid2.sizeLocal(); ++i)
    tester.check(grid2.domain(i).empty());

  // Return resulting error code and exit; Tester will shut down POOMA.

  tester.out() << "-------------------------------------------" << std::endl;
  int retval = tester.results("Partition operations");
  Pooma::finalize();
  return retval;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: ugp_test.cpp,v $   $Author: luchini $
// $Revision: 1.7 $   $Date: 2000/06/12 19:17:03 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
