// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_DOMAIN_DOMAIN_TRAITS_INT_H
#define POOMA_DOMAIN_DOMAIN_TRAITS_INT_H

//-----------------------------------------------------------------------------
// Class:
//   DomainTraits<T>, for T = char, short, int, long, and unsigned versions
//-----------------------------------------------------------------------------

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview:
// DomainTraits<int> is a specialization of the general DomainTraits
// class, for the case of integers.  Integers can often be used in
// combination with other domain types, and the traits class defines how
// they interact with those other domains.  Generally, an int gets promoted
// to a Loc or Interval, based on the context, but in some cases the
// int is used directly.
//
// This also defines the same kind of traits for long, char and short.
// Both are treated just as if they were int's for Domain purposes.  The
// same is true for the unsigned versions of these integral types.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

#include "Domain/DomainTraits.h"

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

template<int Dim> class Interval;
template<int Dim> class Loc;

//-----------------------------------------------------------------------------
//
// Full Description:
//
// DomainTraits<int> stores the characteristics of integers when they are
// used to specify domains in expressions and object constructors.  An int
// behaves differently in different situations; for example, when used to
// construct a new, separate domain object, an int acts just like a Loc<1>
// object.  When used to construct an Array, an int acts just like an
// Interval<1> object, for an interval [0 ... intval - 1].
//
// Since we do not ever have int as a domain "type", just in constructors
// and subset objects, then we need only define the bare minimum of info
// in this traits class.
//
// Identical traits are defined for long, char and short.  Both integral types
// are treated just as if they were ints; they get converted to Interval
// or Loc objects in almost all cases.  The same is true to unsigned versions.
//-----------------------------------------------------------------------------

template<>
struct DomainTraits<char>
  : public DomainTraitsScalar<Interval<1>, int, Loc<1> > { };

template<>
struct DomainTraits<unsigned char>
  : public DomainTraitsScalar<Interval<1>, int, Loc<1> > { };

template<>
struct DomainTraits<short>
  : public DomainTraitsScalar<Interval<1>, int, Loc<1> > { };

template<>
struct DomainTraits<unsigned short>
  : public DomainTraitsScalar<Interval<1>, int, Loc<1> > { };

template<>
struct DomainTraits<int>
  : public DomainTraitsScalar<Interval<1>, int, Loc<1> > { };

template<>
struct DomainTraits<unsigned int>
  : public DomainTraitsScalar<Interval<1>, int, Loc<1> > { };

template<>
struct DomainTraits<long>
  : public DomainTraitsScalar<Interval<1>, int, Loc<1> > { };

template<>
struct DomainTraits<unsigned long>
  : public DomainTraitsScalar<Interval<1>, int, Loc<1> > { };


//////////////////////////////////////////////////////////////////////

#endif     // POOMA_DOMAIN_DOMAIN_TRAITS_INT_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: DomainTraits.int.h,v $   $Author: swhaney $
// $Revision: 1.11 $   $Date: 2000/03/07 13:16:36 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
