// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE, and to allow others to do so.
// The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
// without charge, provided that this Notice and any statement of
// authorship are reproduced on all copies.  Neither the Government nor
// the University makes any warranty, express or implied, or assumes any
// liability or responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Class:
//   Pooma::NoInit
//-----------------------------------------------------------------------------

#ifndef POOMA_UTILITIES_NOINIT_H
#define POOMA_UTILITIES_NOINIT_H

#include "Pooma/Configuration.h"
#include "Utilities/PurifyConstructors.h"

//////////////////////////////////////////////////////////////////////

namespace Pooma {

//-----------------------------------------------------------------------------
//
// class Pooma::NoInit
//
//   Tag class used to signal constructors that certain initializations are
//   to be skipped. 
//
//-----------------------------------------------------------------------------

class NoInit
{
public:
  POOMA_PURIFY_CONSTRUCTORS(NoInit)
};

} // namespace Pooma

//////////////////////////////////////////////////////////////////////

#endif     // POOMA_UTILITIES_NOINIT_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: NoInit.h,v $   $Author: jac $
// $Revision: 1.2 $   $Date: 2000/06/27 04:23:00 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
