// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE, and to allow others to do so.
// The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
// without charge, provided that this Notice and any statement of
// authorship are reproduced on all copies.  Neither the Government nor
// the University makes any warranty, express or implied, or assumes any
// liability or responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
//
// The POOMA Framework
// 
// This program was prepared by the Regents of the University of
// California at Los Alamos National Laboratory (the University) under
// Contract No.  W-7405-ENG-36 with the U.S. Department of Energy (DOE).
// The University has certain rights in the program pursuant to the
// contract and the program should not be copied or distributed outside
// your organization.  All rights in the program are reserved by the DOE
// and the University.  Neither the U.S.  Government nor the University
// makes any warranty, express or implied, or assumes any liability or
// responsibility for the use of this software
//
// Visit http://www.acl.lanl.gov/POOMA for more details
//
//-----------------------------------------------------------------------------
// Pooma general interface test program.
//-----------------------------------------------------------------------------

#include "Pooma/Pooma.h"

using std::cerr;
using std::endl;

void newAbortHandler()
{
  cerr << "Running newly installed abort handler." << endl;
}


int main(int argc, char *argv[])
{
  int i;

  // Print out argc, argv before initialization.

  cerr << "Before initialize: argc = " << argc << ", " << endl;
  for (i=0; i < argc; ++i)
    cerr << "  argv[" << i << "] = '" << argv[i] << "'" << endl;

  // Initialize POOMA

  cerr << "Initializing POOMA ..." << endl;
  Pooma::initialize(argc, argv);

  cerr << "After initialize: argc = " << argc << ", " << endl;
  for (i=0; i < argc; ++i)
    cerr << "  argv[" << i << "] = '" << argv[i] << "'" << endl;

  // Print out some results of POOMA calls to the different POOMA streams

  POOMA_PRINT(Pooma::pinfo, "POOMA version = " << Pooma::version() << endl);

  POOMA_PRINT(Pooma::pwarn, "POOMA build date = " << Pooma::buildDate()<<endl);

  POOMA_PRINT(Pooma::perr, "POOMA major ver = "<< Pooma::majorVersion()<<endl);
  POOMA_PRINT(Pooma::perr, "POOMA minor ver = "<< Pooma::minorVersion()<<endl);

  // Start logging output to a file

  Pooma::logMessages("pooma.out");

  POOMA_PRINT(Pooma::pinfo, "Now logging messages to file 'pooma.out'."<<endl);

  POOMA_PRINT(Pooma::pwarn, "My context = " << Pooma::context() << endl);
  POOMA_PRINT(Pooma::perr, "Total contexts = " << Pooma::contexts() << endl);

  // Do some debugging statements

  POOMA_PRINT(Pooma::pinfo, "About to start printing debug messages." << endl);

  POOMA_DEBUG(0, "This is a level-0 debug message." << endl);

  POOMA_DEBUG(1, "This is a level-1 debug message." << endl);

  POOMA_DEBUG(3, "This is a level-3 debug message." << endl);

  POOMA_DEBUG(5, "This is a level-5 debug message." << endl);

  // Shut down POOMA

  Pooma::pinfo << "Shutting down POOMA with finalize()..." << endl;

  Pooma::finalize();

  return 0;
}


// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: finalize.cpp,v $   $Author: gam $
// $Revision: 1.3 $   $Date: 1999/09/22 19:20:10 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
