/* -*- C -*- */
/* ACL:license */
/* ----------------------------------------------------------------------
 * This software and ancillary information (herein called "SOFTWARE")
 * called POOMA (Parallel Object-Oriented Methods and Applications) is
 * made available under the terms described here.  The SOFTWARE has been
 * approved for release with associated LA-CC Number LA-CC-98-65.
 * 
 * Unless otherwise indicated, this SOFTWARE has been authored by an
 * employee or employees of the University of California, operator of the
 * Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
 * the U.S. Department of Energy.  The U.S. Government has rights to use,
 * reproduce, and distribute this SOFTWARE. The public may copy, distribute,
 * prepare derivative works and publicly display this SOFTWARE without 
 * charge, provided that this Notice and any statement of authorship are 
 * reproduced on all copies.  Neither the Government nor the University 
 * makes any warranty, express or implied, or assumes any liability or 
 * responsibility for the use of this SOFTWARE.
 * 
 * If SOFTWARE is modified to produce derivative works, such modified
 * SOFTWARE should be clearly marked, so as not to confuse it with the
 * version available from LANL.
 * 
 * For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
 * or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
 * ----------------------------------------------------------------------
 */
/* ACL:license */

#ifndef POOMA_POOMA_CONFIGURATION_H
#define POOMA_POOMA_CONFIGURATION_H

/*-----------------------------------------------------------------------------
// Classes:
// (none; this file is used to properly include configuration-option files)
//---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
// Overview:
//
// Config settings are found in a file 'lib/$(SUITE)/PoomaConfiguration.h';
// but this file does not exist for all compiler environments.  This file
// is used to determine if that other configuration file should be included.
// If that file should be used, POOMA should also be compiled with a -I
// statement to look for include files in 'lib/$(SUITE)'.
//
// On systems where there is no configure-generated include file, define
// the symbol POOMA_NO_POOMA_CONFIGURATION_FILE, and put the actual settings
// for various symbols in another location.
//---------------------------------------------------------------------------*/

#ifndef POOMA_NO_POOMA_CONFIGURATION_FILE
# include "PoomaConfiguration.h"
#endif


#endif     /* POOMA_POOMA_CONFIGURATION_H */

/* ACL:rcsinfo */
/* ----------------------------------------------------------------------
 * $RCSfile: Configuration.h,v $   $Author: swhaney $
 * $Revision: 1.6 $   $Date: 2000/03/07 13:18:01 $
 * ----------------------------------------------------------------------
 */
/* ACL:rcsinfo */
