//-----------------------------------------------------------------------------
// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------
#include <string>
#include <iostream>
#include "IO/MultiStorageObjectSets.h"

#include "Utilities/Tester.h"
#include "Pooma/Pooma.h"

//-----------------------------------------------------------------------------
// Test of MultiStorageObjectSet
//-----------------------------------------------------------------------------

int main(int argc, char *argv[])
{

  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

  tester.out() <<"Test of MultiStorageObjectSet:"<< std::endl;
  // Open a new multifile object set.

  MultiStorageObjectSet obset1("MultiFile.dat",Create);
	
  // Add two new object storage sets to it.
  StorageSetID_t ssID1, ssID2;
  ssID1= obset1.openStorageSet("file1.dat", Create);
  tester.out()<<"Storage set opened as #"<<ssID1<<std::endl;
  ssID2= obset1.openStorageSet("file2.dat", Create);
  tester.out()<<"Storage set opened as #"<<ssID2<<std::endl;
	
  // Store an object in each storage set with a label.
  double d= 3.1415;
  int k= 1234;
	
  ObjectID_t gid1, gid2;
	
  gid1= obset1.store(d, ssID1, "doubleval");
  tester.out()<<"double object stored with global ID="
	   <<gid1<<std::endl;
  gid2= obset1.store(k, ssID2, "intval");
  tester.out()<<"int object stored with global ID="
	   <<gid2<<std::endl;

  // Close the object storage set.
  obset1.close();
	
  // Restore as a different object.
  MultiStorageObjectSet obset2("MultiFile.dat",Restore);
	
  // Retrieve the objects by label;
  double d2;
  int k2;
  obset2.retrieve(d2,"doubleval");
  tester.out()<<"double object retrieved, value="
	   <<d2<<std::endl;
  obset2.retrieve(k2,"intval");
  tester.out()<<"int object retrieved, value="
	   <<k2<<std::endl;

  tester.check(d==d2);
  tester.check(k==k2);
	
  // Close it up.
  obset2.close();

  int retval = tester.results("Test of MultiStorageObjectSet");


  Pooma::finalize();
  return retval;
}




