// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_DOMAIN_ARITH_OPS_TRAITS_H
#define POOMA_DOMAIN_ARITH_OPS_TRAITS_H


//-----------------------------------------------------------------------------
// Class:
// DomainArithOpsTraits
//-----------------------------------------------------------------------------

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
// DomainArithOpsTraits is intended to be used to select the return type of 
// arithmatic operations between domains and pseudo-domains comprising the following
// list:

// Loc<1> Loc<N> Interval<N> Range<N> IndirectionList<int> Grid<N>

// Valid combinations are

// Loc<1> +-*/ Loc<1>               => Loc<1>
// Loc<1> +-*/ Loc<N>               => Loc<N>
// Loc<1> +-*/ Interval<N>          => Interval<N>
// Loc<1> +-*/ Range<N>             => Range<N>
// Loc<1> +-*/ IndirectionList<int> => IndirectionList<int>
// Loc<1> +-*/ Grid<N>              => Grid<N>

// Loc<N> +-*/ Loc<N>               => Loc<N>
// Loc<N> +-*/ Interval<N>          => Interval<N>
// Loc<N> +-*/ Range<N>             => Range<N>
// Loc<N> +-*/ Grid<N>              => Grid<N>





//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------


template<int Dim>
class Loc;

template<int Dim>
class Interval;

template<int Dim>
class Range;

template<class T> 
class IndirectionList;

template<int Dim>
class Grid;


template<class T1,class T2 >
struct DomainArithOpsTraits
{
};

template <>
struct DomainArithOpsTraits< Loc<1> , Loc<1> >
{
  typedef Loc<1> AddResult_t;
  typedef Loc<1> SubResult_t;
  typedef Loc<1> MultResult_t;
};

template<int Dim>
struct DomainArithOpsTraits<Loc<1> , Loc<Dim> >
{
  typedef Loc<Dim> AddResult_t;
  typedef Loc<Dim> SubResult_t;
  typedef Loc<Dim> MultResult_t;
};

template<int Dim>
struct DomainArithOpsTraits<Loc<Dim> , Loc<1> >
{
  typedef  Loc<Dim> AddResult_t;
  typedef  Loc<Dim> SubResult_t;
  typedef  Loc<Dim> MultResult_t;
};

template<int Dim,int Dim2>
struct DomainArithOpsTraits<Loc<Dim> , Loc<Dim2> >
{
  typedef  Loc<Dim> AddResult_t;
  typedef  Loc<Dim> SubResult_t;
  typedef  Loc<Dim> MultResult_t;
};


//interval

template<int Dim>
struct DomainArithOpsTraits<Loc<1> , Interval<Dim> >
{
  typedef  Interval<Dim> AddResult_t;
  typedef  Range<Dim> SubResult_t;
  typedef  Range<Dim> MultResult_t;
};

template<int Dim>
struct DomainArithOpsTraits<Interval<Dim>, Loc<1>  >
{
  typedef  Interval<Dim> AddResult_t;
  typedef  Interval<Dim> SubResult_t;
  typedef  Range<Dim> MultResult_t;
};

template<int Dim,int Dim2>
struct DomainArithOpsTraits<Loc<Dim> , Interval<Dim2> >
{
  typedef  Interval<Dim> AddResult_t;
  typedef  Range<Dim> SubResult_t;
  typedef  Range<Dim> MultResult_t;
};

template<int Dim,int Dim2>
struct DomainArithOpsTraits<Interval<Dim>, Loc<Dim2>  >
{
  typedef  Interval<Dim> AddResult_t;
  typedef  Interval<Dim> SubResult_t;
  typedef  Range<Dim> MultResult_t;
};

//Range

template<int Dim>
struct DomainArithOpsTraits<Loc<1> , Range<Dim> >
{
  typedef  Range<Dim> AddResult_t;
  typedef  Range<Dim> SubResult_t;
  typedef  Range<Dim> MultResult_t;
};

template<int Dim>
struct DomainArithOpsTraits<Range<Dim>, Loc<1>  >
{
  typedef  Range<Dim> AddResult_t;
  typedef  Range<Dim> SubResult_t;
  typedef  Range<Dim> MultResult_t;
};

template<int Dim,int Dim2>
struct DomainArithOpsTraits<Loc<Dim> , Range<Dim2> >
{
  typedef  Range<Dim> AddResult_t;
  typedef  Range<Dim> SubResult_t;
  typedef  Range<Dim> MultResult_t;
};

template<int Dim,int Dim2>
struct DomainArithOpsTraits<Range<Dim>, Loc<Dim2>  >
{
  typedef  Range<Dim> AddResult_t;
  typedef  Range<Dim> SubResult_t;
  typedef  Range<Dim> MultResult_t;
};


//IndirectionList<int>


template< >
struct DomainArithOpsTraits<Loc<1> , IndirectionList<int> >
{
  typedef  IndirectionList<int> AddResult_t;
  typedef  IndirectionList<int> SubResult_t;
  typedef  IndirectionList<int> MultResult_t;
};

template< >
struct DomainArithOpsTraits<IndirectionList<int>, Loc<1>  >
{
  typedef  IndirectionList<int> AddResult_t;
  typedef  IndirectionList<int> SubResult_t;
  typedef  IndirectionList<int> MultResult_t;
};

//Grid

 
template<int Dim>
struct DomainArithOpsTraits<Loc<1> , Grid<Dim> >
{
  typedef  Grid<Dim> AddResult_t;
  typedef  Grid<Dim> SubResult_t;
  typedef  Grid<Dim> MultResult_t;
};

template<int Dim>
struct DomainArithOpsTraits<Grid<Dim>, Loc<1>  >
{
  typedef  Grid<Dim> AddResult_t;
  typedef  Grid<Dim> SubResult_t;
  typedef  Grid<Dim> MultResult_t;
};

template<int Dim,int Dim2>
struct DomainArithOpsTraits<Loc<Dim> , Grid<Dim2> >
{
  typedef  Grid<Dim> AddResult_t;
  typedef  Grid<Dim> SubResult_t;
  typedef  Grid<Dim> MultResult_t;
};

template<int Dim,int Dim2>
struct DomainArithOpsTraits<Grid<Dim>, Loc<Dim2>  >
{
  typedef  Grid<Dim> AddResult_t;
  typedef  Grid<Dim> SubResult_t;
  typedef  Grid<Dim> MultResult_t;
};


#endif
