#!/usr/bin/env perl 
# ACL:license
#  ----------------------------------------------------------------------
#  This software and ancillary information (herein called "SOFTWARE")
#  called POOMA (Parallel Object-Oriented Methods and Applications) is
#  made available under the terms described here.  The SOFTWARE has been
#  approved for release with associated LA-CC Number LA-CC-98-65.
#  
#  Unless otherwise indicated, this SOFTWARE has been authored by an
#  employee or employees of the University of California, operator of the
#  Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
#  the U.S. Department of Energy.  The U.S. Government has rights to use,
#  reproduce, and distribute this SOFTWARE, and to allow others to do so.
#  The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
#  without charge, provided that this Notice and any statement of
#  authorship are reproduced on all copies.  Neither the Government nor
#  the University makes any warranty, express or implied, or assumes any
#  liability or responsibility for the use of this SOFTWARE.
#  
#  If SOFTWARE is modified to produce derivative works, such modified
#  SOFTWARE should be clearly marked, so as not to confuse it with the
#  version available from LANL.
#  
#  For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
#  or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
#  ----------------------------------------------------------------------
# ACL:license

#
# Lee Ankeny, 24-Jan-97
# Lee Ankeny, 9/22/97, minor housecleaning
#
# Massage a makefile to correctly identify dependencies of source files.
#
# Given a makefile, read it, split on the $MAKEFILE string, and insert
# $(SUITE) in front of all the object file dependencies which follow $MAKEFILE.
# Write only the dependencies back to the same file.
#
# Usage:
#	dependo.pl <makefile> <dependfile> [CLEAR]
###############################################################################

$DEBUG               = 3;
$VERSION             = "23-July-1997";
$VERSION             = "22-Sep-1997";
$VERSION             = "02-Mar-1998";
$PROGRAM             = $0; $PROGRAM =~ s/.*\/(.*)$/$1/;

local($makefile)     = shift @ARGV; # The first arg is the name of the make file.
local($dependfile)   = shift @ARGV; # The second arg is the name of the dependency file.
local($PROJECT_ROOT) = shift @ARGV; # 
local($flag)         = shift @ARGV; # 
#local($MAKELINE)     = "# DO NOT DELETE THIS LINE -- make depend depends on it.";
local($MAKELINE)     = "# DO NOT DELETE";

# Slurp up the whole make file.
undef $/;
open (M, $makefile) || die "$PROGRAM: 1 Couldn't open $makefile for reading\n";
$_ = <M>;
close (M);

# Split the makefile on the line inserted by makedepend.
($top,$bottom) = split(/$MAKELINE/);

# Make sure makedepend has been run on the make file.
unless ($bottom) {
	print STDERR "No makedepend depencencies found in $makefile\n";
	exit;
}

# 
if ($flag =~ "CLEAR") {
	open (M, ">$makefile") || die "$PROGRAM: 2 Couldn't open $makefile for writing\n";
	print M $top;
	close (M);
	exit;
}

$* = 1;	# necessary for perl 4.
$bottom =~ s#(.*)(/.*\.o:)#$1/\$(SUITE)$2#g;    # Insert $(SUITE)/
$bottom =~ s|\Q$PROJECT_ROOT\E|\$(PROJECT_ROOT)|g;  # Replace path with env variable
$bottom =~ s/\n{2,}//g;                         # Strip blank lines

# Rewrite the make file.
open (M, ">$makefile") || die "$PROGRAM: 3 Couldn't open $makefile for writing\n";
#print M $top,$MAKELINE,$bottom;
print M $bottom;
close (M);

exit;

__END__
Anything after __END__ is ignored by the perl interpreter
# Debugging fragments:
if ($DEBUG > 1) {
	print "*" x 50, "\n";
	print "_:        $_\n";
	print "=" x 50, "\n";
	print "top:      $top\n";
	print "makeline: $makeline\n";
	print "bottom:   $bottom\n";
}

print "bottom:   $bottom\n" if $DEBUG;

if ($DEBUG > 2) {
	print "ARGV:  @ARGV\n";
}

	if ($DEBUG) {
		print "obj=$obj\n";
		print "src=$src\n";
		print "spath=$spath\n";
		print "mpath=$mpath\n";
		print "object=$object\n";
	}

# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: dependo.pl,v $   $Author: julianc $
#  $Revision: 1.8 $   $Date: 1999/10/15 22:31:47 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
