#!/bin/csh -f
set backupdir="/mm/ftp/pub/tgif/www"
set tmp_gz="/tmp/tgif-faq.tar.Z"
set target="$backupdir/tgif-faq.tar.Z"

set files="faq"

echo "rm -f $tmp_gz"
rm -f "$tmp_gz"
echo "tar cf - $files | compress -c > $tmp_gz"
tar cf - "$files" | compress -c > "$tmp_gz"

if ( -f "$target" ) then
    set result=`cmp $target $tmp_gz`
    if ( "$result" == "") then
        echo "No changes detected in the FAQ files on `date`."
    else
        echo "rm -f $target"
        rm -f "$target"
        echo "cp $tmp_gz $target"
        mv "$tmp_gz" "$target"
        /usr/ucb/mail -s "TGIF automessage..." william < backup-tgif-faq.txt
    endif
else
    echo "cp $tmp_gz $target"
    mv "$tmp_gz" "$target"
endif
