/*
 *  $Id: strcmp_wild.c,v 1.1.1.2 1999/01/25 16:27:23 thhsieh Exp $
 */
/*
    Copyright (C) 1999 by  XCIN TEAM

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For any question or suggestion, please mail to xcin mailing-list:
    xcin@linux.org.tw, or the maintainer Tung-Han Hsieh: thhsieh@linux.org.tw
*/      


#include <stdlib.h>
#include <string.h>
#include "xcintool.h"

static int 
cmp1(char *s1, char **s2, int slen)
{
    (*s2) ++;
    if (! **s2)
        return  1;
    return  strncmp(s1, *s2, slen);
}

static int 
cmp2(char *s1, char **s2, int slen)
{
    int ret=1;

    while (ret && (*s2) && (**s2)) {
        if ((*s1) == (**s2))
	    ret = strncmp(s1, *s2, slen);
	if (ret)
	    (*s2) ++;
    }

    return  ret;
}

int
strcmp_wild(char *s1, char *s2)
{
    char *ss1, *sp=s1, *cp1, *cp2=s2, wild='\0', *tok=NULL;
    int slen, ret;

    cp1 = ss1 = strdup(s1);
    
    while (cp1 && *cp1) {
        tok = strsep(&cp1, "*?");
        slen = strlen(tok);
	if (cp1 && *cp1 == '*')
            cp1 ++;

	if (wild == '\0') {
	    if ((ret = strncmp(tok, cp2, slen)) != 0) {
	        ret = (ret > 0) ? 1 : -1;
		break;
	    }
	}
	else if (wild == '?') {
	    if ((ret=cmp1(tok, &cp2, slen)) != 0) {
	        ret = (ret > 0) ? 1 : -1;
		break;
	    }
	}
	else if (wild == '*') {
	    if ((ret=cmp2(tok, &cp2, slen)) != 0) {
	        ret = (ret > 0) ? 1 : -1;
		break;
	    }
	}

	cp2 += slen;
	while (sp && *sp && *sp != '?' && *sp != '*')
	    sp ++;
	wild = (sp && *sp) ? *sp : '\0';
	sp ++;
    }

    if (! ret) {
        if (cp2 && *cp2) {
	    if (wild == '?') {
	        cp2 ++;
	        ret = (*cp2) ? -1 : 0;
	    }
	    else if (wild == '*')
	        ret = 0;
	    else
	        ret = -1;
        }
        else if (wild == '?')
	    ret = 1;
        else
            ret = 0;
    }

    free(ss1);
    return  ret;
}


