/*
    Copyright (C) 1999 by  XCIN TEAM

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For any question or suggestion, please mail to xcin mailing-list:
    xcin@linux.org.tw, or the maintainer Tung-Han Hsieh: thhsieh@linux.org.tw
*/      

#include <stdio.h>
#include "xcintool.h"

FILE *
open_data(char *fn, char *md, char *default_p, char *user_p, char *sub_p, 
	  char *locale_subp, char *true_fn, int true_size, int exitcode)
{
    FILE *f;
    char *path, path_buf[256], *sp;
    int buf_size;

    if (true_fn) {
	path = true_fn;
	buf_size = true_size;
    }
    else {
	path = path_buf;
	buf_size = 256;
    }
    sp = (sub_p) ? sub_p : ".";

    if (locale_subp) {
	snprintf(path, buf_size, "%s/%s/%s/%s", user_p, sp, locale_subp, fn);
	if ((f = fopen(path, md)))
	    return f;
    }
    snprintf(path, buf_size, "%s/%s/%s", user_p, sp, fn);
    if ((f = fopen(path, md)))
	return f;
    snprintf(path, buf_size, "%s/%s", user_p, fn);
    if ((f = fopen(path, md)))
	return f;

    if (locale_subp) {
	snprintf(path, buf_size, "%s/%s/%s/%s", default_p, sp, locale_subp, fn);
	if ((f = fopen(path, md)))
	    return f;
    }
    snprintf(path, buf_size, "%s/%s/%s", default_p, sp, fn);
    if ((f = fopen(path, md)))
	return f;
    snprintf(path, buf_size, "%s/%s", default_p, fn);
    if ((f = fopen(path, md)))
	return f;

    if (exitcode != XCINMSG_EMPTY && exitcode != XCINMSG_NORMAL)
	perr(exitcode, _("cannot open data file: %s\n"), fn);

    return NULL;
}
