/*
 * Copyright 1999, TaBE Project, All Rights Reserved.
 * Copyright 1999, Pai-Hsiang Hsiao, All Rights Reserved.
 *
 * $Id: tsiadd.c,v 1.3 1999/05/11 11:22:05 shawn Exp $
 *
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include <tabe.h>

void
usage()
{
  printf("Usage: tsiadd -d <TsiDB> [-f input file -r -y]\n");
  exit(0);
}

void
archive(db, fp, ref, tsiyin)
struct TsiDB *db;
FILE *fp;
int ref, tsiyin;
{
  struct TsiInfo *tsi;
  int rval, i, j, l, m, n, len;
  unsigned char buf[1000], yin[1000], tmpyin[20], *p, *q;
  unsigned long int refcount;

  rval = db->RecordNumber(db);
  if (rval < 0) {
    fprintf(stderr, "tsidump: wrong DB format.\n");
    usage();
  }

  tsi = (struct TsiInfo *)malloc(sizeof(struct TsiInfo));
  tsi->tsi = (ZhiStr)malloc(sizeof(unsigned char)*80);
  memset(tsi->tsi, 0, 80);
  tsi->refcount = 0;
  tsi->yinnum = 0;
  tsi->yindata = (Yin *)NULL;

  memset(buf, 0, 1000);
  memset(yin, 0, 1000);

  i = j = 0;
  while (1) {
    if (!fgets(buf, 1000, fp)) {
      break;
    }
    i++;
    yin[0] = (unsigned char)NULL;
    if (!ref) {
      buf[strlen(buf)-1] = (unsigned char)NULL;
      strcpy(tsi->tsi, buf);
    }
    else {
      sscanf(buf, "%20s %ld %s\n", tsi->tsi, &refcount, yin);
      tsi->refcount = refcount;
    }
    len = strlen(tsi->tsi)/2;
    if (strlen(yin)) {
      l = 0;
      p = yin;
      while ((p = strstr(p, "@"))) {
        p++;
        l++;
      }
      tsi->yinnum = (l+1)/len;
      tsi->yindata = (Yin *)realloc(tsi->yindata, sizeof(Yin)*(l+1));
      p = yin;
      for (m = 0; m < tsi->yinnum; m++) {
        for (n = 0; n < len; n++) {
           q = strstr(p, "@");
           if (q) {
             strncpy(tmpyin, p, q-p);
             tmpyin[q-p] = (unsigned char)NULL;
             tsi->yindata[m*len+n] = tabeZuYinSymbolSequenceToYin(tmpyin);
             p = q+2;
           }
           else {
             strncpy(tmpyin, p, strlen(p));
             tmpyin[strlen(p)] = (unsigned char)NULL;
             tsi->yindata[m*len+n] = tabeZuYinSymbolSequenceToYin(tmpyin);
             break;
           }
        }
      }
    }
    else {
      tabeTsiInfoLookupPossibleTsiYin(tsi);
      if (tsi->yinnum > 1) {
        tsi->yinnum = 0;
        free(tsi->yindata);
        tsi->yindata = NULL;
      }
    }
    db->flags |= DB_FLAG_OVERWRITE;
    rval = db->Put(db, tsi);
    db->flags ^= DB_FLAG_OVERWRITE;
    if (!rval) {
      j++;
    }
    if (tsi->yinnum) {
      free(tsi->yindata);
      tsi->yindata = NULL;
    }
  }

  printf("There're %d queries, %d added.\n", i, j);
  db->Close(db);
}

int
main(argc, argv)
int argc;
char **argv;
{
  char ch;
  int ref, tsiyin;
  FILE *fp;
  struct TsiDB *db;

  char *db_name, *op_name;

  db_name = op_name = (char *)NULL;
  ref = 0;
  tsiyin = 0;

  while ((ch = getopt(argc, argv, "d:f:ry")) != -1) {
    switch(ch) {
      case 'd':
        db_name = strdup(optarg);
        break;
      case 'f':
        op_name = strdup(optarg);
        break;
      case 'r':
        ref = 1;
        break;
      case 'y':
        tsiyin = 1;
        break;
      default:
        usage();
        break;
    }
  }
  argc -= optind;
  argv += optind;

  if (!db_name) {
    usage();
  }

  db = tabeTsiDBOpen(DB_TYPE_DB, db_name, DB_FLAG_CREATEDB);
  if (!db) {
    usage();
  }

  if (op_name) {
    fp = fopen(op_name, "r");
    archive(db, fp, ref, tsiyin);
    fclose(fp);
  }
  else {
    archive(db, stdout, ref, tsiyin);
  }

  return(0);
}
