/*
 *  $Id: xcintool.h,v 1.5 1999/02/18 08:09:29 thhsieh Exp $
 */
/*
    Copyright (C) 1999 by  XCIN TEAM

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For any question or suggestion, please mail to xcin mailing-list:
    xcin@linux.org.tw, or the maintainer Tung-Han Hsieh: thhsieh@linux.org.tw
*/      


#ifndef _TOOLFUNC_H
#define _TOOLFUNC_H

#include <stdio.h>
#include <stdlib.h>
#include "constant.h"

#ifdef HAVE_GETTEXT
#include <libintl.h>
#define _(STRING) gettext(STRING)
#else
#define _(STRING) STRING
#endif

/* Where we use GCC special feature of DebugLog */
#ifdef DEBUG
#  define   DebugLog(fmt, args...) {                                    \
                fprintf(stderr, "%s(%d): Debug: ", __FILE__, __LINE__); \
                fprintf(stderr, fmt, ##args);                           \
            }
#else
#  define   DebugLog(fmt, args...)
#endif


/* For general message level. */
#define XCINMSG_NORMAL		 0		/* normal		*/
#define XCINMSG_WARNING		 1		/* warning		*/
#define XCINMSG_IWARNING	 2		/* internal warnning	*/
#define XCINMSG_ERROR		-1		/* error		*/
#define XCINMSG_IERROR		-2		/* internal error	*/
#define XCINMSG_EMPTY		 3		/* pure message printed */


/* General char type: mbs encoding
 *
 * Note: In Linux, if wch_t.s = "a1 a4", then wch_t.wch = 0xa4a1, i.e.,
 *       the order reversed. This might not be the general case for all
 *       plateforms.
 */
#ifndef WCH_SIZE
#define WCH_SIZE  4
typedef union { 
    unsigned char s[WCH_SIZE];
    wchar_t wch;
} wch_t;
#endif

/* File type for check_file_exist(); */
enum ftype {
    FTYPE_FILE,
    FTYPE_DIR,
    NONE
};

/* Input data type  */
enum rctype {
    RC_BFLAG,
    RC_SFLAG,
    RC_IFLAG,
    RC_LFLAG,
    RC_BYTE,
    RC_UBYTE,
    RC_SHORT,
    RC_USHORT,
    RC_INT,
    RC_UINT,
    RC_LONG,
    RC_ULONG,
    RC_FLOAT,
    RC_DOUBLE,
    RC_STRING,
    RC_STRARR,
    RC_NONE
};


extern void set_perr(char *error_head);
extern void perr(int exitcode, const char *fmt,...);
extern void locale_setting(char **lc_ctype, char **lc_messages, int exitcode);

extern FILE *open_file(char *fn, char *md, int exitcode);
extern FILE *open_data(char *fn, char *md, char *default_p, char *user_p, 
	char *sub_p, char *locale_subp, char *true_fn, int true_size, int exitcode);
extern void copy_file(char *fn1, char *fn2, int exitcode);
extern int check_file_exist(char *path, enum ftype type);
extern int check_version(char *vaild_version, char *version, int const_str);

extern int get_line(char *str, int str_size, FILE *f, int *lineno, 
	char *ignore_ch);
extern int get_word(char **line, char *word, int word_size, char *token);
extern void set_data(void *ref, int type, char *value, 
	unsigned long flag_mask, int bufsize);
extern int strcmp_wild(char *s1, char *s2);
extern char *wchs_to_mbs(char *mbs, wch_t *wchs, int size);
extern int wchs_len(wch_t *wchs);
extern void stable_sort(void *base, size_t nmemb, size_t size,
            int (*compar)(const void *, const void *));

extern void read_resource(char *rc_fn);
extern int get_resource(char **cmd_list, char *value, int v_size, int n_cmd_list);
extern char *read_xcinrc(char *rcfn, char *user_home);


#endif
