/*
 * $Id: IC.h,v 1.4 1999/02/18 08:09:20 thhsieh Exp $
 */

#ifndef _IC_H
#define _IC_H
/******************************************************************
 
         Copyright 1994, 1995 by Sun Microsystems, Inc.
         Copyright 1993, 1994 by Hewlett-Packard Company
 
Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of Sun Microsystems, Inc.
and Hewlett-Packard not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.
Sun Microsystems, Inc. and Hewlett-Packard make no representations about
the suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.
 
SUN MICROSYSTEMS INC. AND HEWLETT-PACKARD COMPANY DISCLAIMS ALL
WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SUN MICROSYSTEMS, INC. AND HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 
  Author: Hidetoshi Tajima(tajima@Eng.Sun.COM) Sun Microsystems, Inc.
 
******************************************************************/

#include <X11/Xlib.h>           /* for IMdkit.h/Xpointer */
#include "Ximd/IMdkit.h"
#include "Ximd/Xi18n.h"
#include "imodule.h"

typedef struct {
    XRectangle	area;		/* area */
    XRectangle	area_needed;	/* area needed */
    XPoint	spot_location;	/* spot location */
    Colormap	cmap;		/* colormap */
    CARD32	foreground;	/* foreground */
    CARD32	background;	/* background */
    Pixmap	bg_pixmap;	/* background pixmap */
    char	*base_font;	/* base font of fontset */
    CARD32	line_space;	/* line spacing */
    Cursor	cursor;		/* cursor */
} PreeditAttributes;

typedef struct {
    XRectangle	area;		/* area */
    XRectangle	area_needed;	/* area needed */
    Colormap	cmap;		/* colormap */
    CARD32	foreground;	/* foreground */
    CARD32	background;	/* background */
    Pixmap	bg_pixmap;	/* background pixmap */
    char	*base_font;	/* base font of fontset */
    CARD32	line_space;	/* line spacing */
    Cursor	cursor;		/* cursor */
} StatusAttributes;

enum {
    SPELLING_INCOMPLETE,
    SPELLING_COMPLETE,          /* just before posting selection */
};
enum {
    PREEDIT_EDITING,
    PREEDIT_SELECTION
};

enum {
    SEL_LEFT,
    SEL_MID,
    SEL_RIGHT
};


/*
 *  Flags for inp_state of each IC.
 */
#define IC_CINPUT  	0x01
#define IC_2BYTES  	0x02
#define IC_XIMINIT 	0x10
#define IC_XIMFOCUS	0x20
#define IC_NEWIC	0x40

typedef unsigned char  inp_state_t;

typedef struct _IC IC; /* forward declaration */
struct _IC {
    CARD16		id;		/* ic id */
    CARD16		connect_id;	/* id of connected client */
    time_t		exec_time;	/* recent excution time. */
    struct _IC	       *next;
    inp_state_t		inp_state;      /* ic cinput state */
    inp_state_t		inp_num;        /* ic cinput num */
    inp_state_t		sinp_num;       /* ic cinput num (sinmd) */
    imodule_t	       *imodp;		/* current binding cinput module */
    imodule_t	       *s_imodp;	/* show keystroke cinput module */
    inpinfo_t 		inpinfo;	/* inp info referenced by gui */
    unsigned int	skey_size;	/* sinmd_keystroke buf size. */
    wch_t 	       *sinmd_keystroke;/* for keystroke of a published cch. */
    unsigned int	cch_size;	/* cch buf size. */
    char	       *cch;		/* composed char for commit. */

/*
 *  Set from: XICAttribute *ic_attr, *pre_attr, *sts_attr;  
 *  ic_set_value_by_name();
 */
    INT32		input_style;	/* input style */
    Window		client_win;	/* client window */
    Window		focus_win;	/* focus window */
    char	       *resource_name;	/* resource name */
    char	       *resource_class; /* resource class */
    PreeditAttributes   pre_attr;	/* preedit attributes */
    StatusAttributes	sts_attr;	/* status attributes */
};


extern IC *ic_find(CARD16 icid);
extern int ic_create(XIMS ims, IMChangeICStruct *call_data);
extern int ic_destroy(XIMS ims, IMDestroyICStruct *call_data);
extern int ic_clean_all(CARD16 connect_id);
extern int ic_get(XIMS ims, IMChangeICStruct *call_data);
extern int ic_set(XIMS ims, IMChangeICStruct *call_data);
extern void check_ic_exist(int icid);


#endif /* _IC_H */
