/*
    Copyright (C) 1999 by  XCIN TEAM

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For any question or suggestion, please mail to xcin mailing-list:
    xcin@linux.org.tw, or the maintainer Tung-Han Hsieh: thhsieh@linux.org.tw
*/      

#include <string.h>
#include "xcintool.h"
#include "xcin_core.h"
#include "imodule.h"

typedef struct {
    short n;
    char *s;
} qphr_t;

static qphr_t qphr[50];
static char true_fn[256];

void
qphrase_init(void)
{
    char *s, buf[256], cmd[5], var[80];
    int lineno=0, key;
    FILE *fp;
   
    fp = open_data(xcin_conf.phrase_fn, "rt", xcin_conf.default_dir, 
	    xcin_conf.user_dir, "tab", xcin_conf.locale.lc_ctype, true_fn, 
	    256, XCINMSG_WARNING);
    if (! fp)
	return;

    while (get_line(buf, 256, fp, &lineno, "#\n")) {
	s = buf;
	get_word(&s, cmd, 5, NULL);
	if (! (key = key2code(cmd[0])))
	    continue;
	if (! get_word(&s, var, 80, NULL))
	    continue;

	qphr[key].n = strlen(var);
	qphr[key].s = strdup(var);
    }
}

char *
qphrase_str(int ch)
{
    int key;

    if ((key = key2code(ch)) && qphr[key].n > 0)
	return qphr[key].s;
    else
	return NULL;
}
