/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 2001, William Chia-Wei Cheng.
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Trolltech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/version.c,v 4.12 2001/10/16 01:30:45 william Exp $
 */

#define _INCLUDE_FROM_VERSION_C_

#include "tgifdefs.h"
#include "patchlvl.h"

#include "version.e"

char *versionString="4.1";
char *authorEmailString="bill.cheng@acm.org";
#ifdef QPL_LICENSE
char *copyrightString="Copyright (C) 2001, William Chia-Wei Cheng";
#else /* ~QPL_LICENSE */
char *copyrightString="Copyright (C) 1990-2001, William Chia-Wei Cheng";
#endif /* QPL_LICENSE */
char *homePageURL="http://bourbon.cs.umd.edu:8001/tgif/";
char *oldMailingList="kragen-tgif@kragen.dnaco.net";
char *mailingList="tgif4-announce@yahoogroups.com";
char *joinMailingList="tgif4-announce-subscribe@yahoogroups.com";
char *currentReleaseURL="http://bourbon.cs.umd.edu:8001/tgif/current.html";
char *hyperGraphicsURL="http://bourbon.cs.umd.edu:8001/tgif/index.obj";

char fullVersionString[MAXSTRING];
char fullToolName[MAXSTRING];
#ifdef QPL_LICENSE
char *specialBuild="QPL";
#else /* ~QPL_LICENSE */
char *specialBuild="";
#endif /* QPL_LICENSE */

void SetFullVersionString()
{
   if (*specialBuild == '\0') {
      sprintf(fullVersionString, "%s.%1d", versionString, TGIF_PATCHLEVEL);
   } else {
      sprintf(fullVersionString, "%s.%1d-%s", versionString, TGIF_PATCHLEVEL,
            specialBuild);
   }
   sprintf(fullToolName, "%s-%s", TOOL_NAME, fullVersionString);
}

void InitVersion()
{
}
