/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 2001, William Chia-Wei Cheng.
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Trolltech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING
 * THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/button.c,v 4.9 2001/08/06 21:38:56 william Exp $
 */

#define _INCLUDE_FROM_BUTTON_C_

#include "tgifdefs.h"

#include "auxtext.e"
#include "box.e"
#include "button.e"
#include "cursor.e"
#include "file.e"
#include "font.e"
#include "mainloop.e"
#include "mainmenu.e"
#include "menu.e"
#include "msg.e"
#include "raster.e"
#include "rect.e"
#include "setup.e"

int ButtonWidth(Str, MinLen)
   char *Str;
   int MinLen;
{
   int len=strlen(Str);

   if (boldMsgFontSet == NULL && boldMsgFontPtr == NULL) {
      return (defaultFontWidth * max(len+2, MinLen));
   } else if (len > MinLen-2) {
      char buf[40];
      int len1=0, len2=0;

      /* do not translate -- the string is used to measure things */
      sprintf(buf, "  %s  ", Str);
      len1 = 4+BoldMsgTextWidth(boldMsgFontPtr, buf, len+4);
      len2 = 4+BoldMsgTextWidth(boldMsgFontPtr, "  CANCEL  ", 10);

      return max(len1,len2);
   } else {
      /* do not translate -- the string is used to measure things */
      return 4+BoldMsgTextWidth(boldMsgFontPtr, "  CANCEL  ", 10);
   }
}

#define BTN_Y_MARGIN 2

void DisplayButtonInBBox(Win, Str, Len, BBox, Normal, HighLight, Width)
   Window Win;
   char *Str;
   int Len, HighLight, Width;
   struct BBRec *BBox;
   int Normal;
   /* Display a button in Win at location ((*BBox).ltx,(*BBox).lty), Str is */
   /*    centered in the button.  The width of the button is given in BBox. */
   /* Len must be strlen(Str) */
   /* If HighLight is TRUE, Width is used to draw an outline around the box. */
{
   int button_w, button_h, left, top, text_w;
   int bg_pixel=(threeDLook ? myLtGryPixel : myBgPixel);

   button_w = BBox->rbx - BBox->ltx;
   button_h = BBox->rby - BBox->lty;
   if (boldMsgFontSet == NULL && boldMsgFontPtr == NULL) {
      text_w = defaultFontWidth * Len;
      left = ((button_w - text_w)>>1);
      top = ((button_h - defaultFontHeight)>>1);
   } else {
      text_w = BoldMsgTextWidth(boldMsgFontPtr, Str, Len);
      left = ((button_w - text_w)>>1);
      top = ((button_h - boldMsgFontHeight)>>1);
   }
   XSetForeground(mainDisplay, defaultGC, (Normal ? bg_pixel : myFgPixel));
   XFillRectangle(mainDisplay, Win, defaultGC, BBox->ltx, BBox->lty,
         button_w, button_h);
   XSetForeground(mainDisplay, defaultGC, myFgPixel);
   if (threeDLook) {
      struct BBRec bbox;

      SetBBRec(&bbox, BBox->ltx, BBox->lty-windowPadding, BBox->ltx+button_w,
            BBox->lty+button_h+windowPadding);
      TgDrawThreeDButton(mainDisplay, Win, textMenuGC, &bbox,
            (Normal ? TGBS_RAISED : TGBS_LOWRED), 2, Normal);
   } else {
      XDrawRectangle(mainDisplay, Win, defaultGC, BBox->ltx, BBox->lty,
            button_w, button_h);
   }
   if (!Normal) {
      XSetForeground(mainDisplay, defaultGC, myBgPixel);
   }
   if (boldMsgFontSet == NULL && boldMsgFontPtr == NULL) {
      DrawBoldMsgString(mainDisplay, Win, defaultGC, BBox->ltx+left,
            BBox->lty+defaultFontAsc+BTN_Y_MARGIN, Str, Len);
   } else {
      if (boldMsgFontPtr != NULL) {
         XSetFont(mainDisplay, defaultGC, boldMsgFontPtr->fid);
      }
      DrawBoldMsgString(mainDisplay, Win, defaultGC, BBox->ltx+left,
            BBox->lty+boldMsgFontAsc+BTN_Y_MARGIN, Str, Len);
      XSetFont(mainDisplay, defaultGC, defaultFontPtr->fid);
   }
   if (!Normal) {
      XSetForeground(mainDisplay, defaultGC, myFgPixel);
   }
   if (HighLight) {
      if (threeDLook) {
         XSetForeground(mainDisplay, defaultGC, myBorderPixel);
         XDrawRectangle(mainDisplay, Win, defaultGC, BBox->ltx-1,
               BBox->lty-windowPadding-1, button_w+1,
               button_h+(windowPadding<<1)+1);
         XSetForeground(mainDisplay, defaultGC, myFgPixel);
      } else {
         XDrawRectangle(mainDisplay, Win, defaultGC, BBox->ltx-Width,
               BBox->lty-Width, button_w+(Width<<1), button_h+(Width<<1));
      }
   }
}
