#!/usr/pkg/gnu/bin/perl

#
# Converts a latex string specified on the command line to an epsi file,
# i.e. and eps file with an included preview bitmap.
#
# Requires:
#
#   latex   
#   dvips
#   gs (with ppm device)
#   pbmtoepsi (from the pbm package)
#
#
# Note:
#
#   The accuracy of the bounding box computation is determined by the 
#   resolution of the file generated by ghostscript which, by default, is
#   in points, and the algorithm used by ghostscript to reduce resolution.
#   The bounding boxes should be accurate to within a point.  I checked
#   this on a couple examples and the bounding boxes generated were off by
#   one point on the bottom and to the right.  The problem comes from the
#   computaion done by pbmtoepsi, which I imagine is always incorrect.
#
# Credit:
#   
#   Using gs and pbmtoepsi to obtain the bounding box was taken from 
#     pstoepsi.
#   The template latex file and dvips command line were taken from a 
#     tgif object for including latex into it.
#
# Robert Estes - 6/1/94
#   estes@cipic.ucdavis.edu
#

#
# Might as well include an option, -bb, to print the bounding box, since we
# mess with it anyways.
#

if ($ARGV[0] =~ /^-bb/) { $printBoundingBox = 1; shift @ARGV; }
else { $printBoundingBox = 0; }

$#ARGV == 1 || die "Usage: latex2epsi [-bb] <latex string> <epsi file name>\n";

$| = 1;

$name = "latex2epsi$$";

open(LATEX,">$name.tex") || die "Cannot open $name.tex\n";

print LATEX <<"EOF";
\\documentstyle{article}

\\oddsidemargin=0in
\\textwidth=6.5in
\\topmargin=0in
\\textheight=609pt
\\parskip=14pt
\\setlength{\\unitlength}{0.5cm}
\\pagestyle{empty}

% Some useful macros

\\def\\centertext#1{\\begin{center}#1\\end{center}}
\\def\\lefttext#1{\\begin{flushleft}#1\\end{flushleft}}
\\def\\righttext#1{\\begin{flushright}#1\\end{flushright}}

\\begin{document}

\\raggedright
\\LARGE

$ARGV[0]

\\end{document}
EOF

close(LATEX);

# Run this separately - so we can see any errors in the input strings.

if (system("latex $name")) 
  {
  system("rm -f $name.*");
  die "Error running LaTeX on '$ARGV[0]'\n"; 
  }

$cmd = "dvips -q -N -n 1 -o $name.ps $name";
$cmd .= " ; echo '($name) ppm1run' | gs -q -dNODISPLAY pstoppm.ps - ".
  "> /dev/null";
$cmd .= " ; pbmtoepsi $name.ppm > $name.epsi";
system($cmd);

# The bounding box generated by pbmtoepsi is off by one point on the left
# and right margins, so I fix it here.

open(HEADER,"<$name.epsi") || die;
open(EPS,">$ARGV[1]") || die;
while (<HEADER>)
  {
  if (/^%%BoundingBox/)
    {
    ($llx,$lly,$urx,$ury) = /(\d+)/go;
    $lly--; $urx++;
    printf EPS "%%%%BoundingBox: $llx $lly $urx $ury\n";
    if ($printBoundingBox) { print "$llx $lly $urx $ury\n"; }
    }
  else { print EPS; }
  }
close(HEADER);
close(EPS);

$cmd = "cat $name.ps >> $ARGV[1]";
$cmd .= " ; rm -f $name.*";
system($cmd);

exit;

#
# The bounding boxes generated by the code below are not very accurate - I
# did one simple test, so, even though the processing is simpler, I chose
# to use the more accurate method above.
#
#$cmd = "latex $name";
#$cmd .= " ; dvips -q -n 1 -E -o $ARGV[1] $name";
#$cmd .= " ; rm -f $name.*";
#
#
