/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-1995, William Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell derivative works of
 * "tgif", and the right to distribute "tgif" for a fee) are
 * reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /u/multimedia/william/X11/TGIF2/RCS/xpixmap.e,v 2.32 1995/05/15 01:20:50 william Exp $
 */

#ifndef _XPIXMAP_E_
#define _XPIXMAP_E_

extern GC	xpmGC;
extern int	newColormapUsed;
extern double	rotatedSine[];
extern double	rotatedCosine[];

extern void	ResetXPmErrorMessage ARGS_DECL((void));
extern void	InitXPm ARGS_DECL((void));
extern void	CleanUpXPm ARGS_DECL((void));
extern void	BuildXPmBuckets ARGS_DECL((int NColors, int *Pixels,
		                          int CharsPerPixel, char *ColorChr));
extern int	XPmLookUp ARGS_DECL((int Pixel, int CharsPerPixel,
		                     char *ColorChr));
extern void	MakeCachedPixmap ARGS_DECL((struct ObjRec *));
extern void	CutXPixmap ARGS_DECL((void));
extern void	DumpXPmObj ARGS_DECL((FILE *, struct ObjRec *));
extern int	NeedsToCacheXPmObj ARGS_DECL((struct ObjRec *));
extern void	DrawXPmObj ARGS_DECL((Window, int XOff, int YOff,
		                      struct ObjRec *));
extern struct ObjRec	* CreateXPmObj ARGS_DECL((int ImageW, int ImageH,
			                          int W, int H, Pixmap,
			                          XImage *, int NColors,
			                          int CharsPerPixel,
			                          int FirstPixelIsBg,
			                          char *ColorChar,
			                          char **ColorStr,
			                          int *Pixels, char *Data));
extern void	SaveXPmObj ARGS_DECL((FILE *, struct ObjRec *));
extern int	QuickFindColorIndex ARGS_DECL((char *Str, int *NewAlloc,
		                               int UseDefault));
extern int	MyReadPixmapFile ARGS_DECL((char *FileName, int *ImageW,
		                            int *ImageH, int *W, int *H,
		                            Pixmap *, XImage **, int *NColors,
		                            int *CharsPerPixel,
		                            int *FirstPixelIsBg,
		                            char **ColorChar, char ***ColorStr,
		                            int **Pixels, char **Data));
extern void	ReadXPmObj ARGS_DECL((FILE *, char *Inbuf, struct ObjRec **));
extern void	FreeXPmObj ARGS_DECL((struct ObjRec *));

#endif /*_XPIXMAP_E_*/
