/*
 * Author:      Your Name <YourEMail>
 *
 * Copyright (C) 199?-199?, Your Name.
 *
 * @(#)$Header: /mm/src/tgif/v4/export-filters/bar/RCS/bar.c,v 4.1 1999/01/11 13:39:27 william Exp $
 */

#include "../../expfdefs.h"

#include "exp1main.h"

#include "bar.e"

#include "bar.xbm"

static int nTgEFVersion=1; /* TGEF_VERSION passed in from Imakefile must be 1 */

/* --------------------- Utility Functions --------------------- */

          /*------------------------------------------*\
          |  This section should not have to change if |
          |      you are using ``protocol version 1''. |
          \*------------------------------------------*/

static
int Call_MsgBox(pUserInfo, Message, Title, IconAndBtns)
   UserInfo *pUserInfo;
   char *Message, *Title;
   int IconAndBtns;
{
   return ((MsgBoxFunc*)(pUserInfo->stProtocolInfo_1.pfnMsgBox))(Message, Title,
         IconAndBtns);
}

static
int Call_Dialog(pUserInfo, Message, Comment, ReturnStr)
   UserInfo *pUserInfo;
   char *Message, *Comment, *ReturnStr;
{
   return ((DialogFunc*)(pUserInfo->stProtocolInfo_1.pfnDialog))(Message,
         Comment, ReturnStr);
}

static
int Call_FailAllocMessage(pUserInfo)
   UserInfo *pUserInfo;
{
   return ((FailAllocMessageFunc*)(
         pUserInfo->stProtocolInfo_1.pfnFailAllocMessage))();
}

static
int Call_UtilCopyFile(pUserInfo, pszFromFile, pszToFile)
   UserInfo *pUserInfo;
   char *pszFromFile, *pszToFile;
{
   return ((UtilCopyFileFunc*)(pUserInfo->stProtocolInfo_1.pfnUtilCopyFile))(
         pszFromFile, pszToFile);
}

static
int Call_ObjInVisibleLayer(pUserInfo, pObj)
   UserInfo *pUserInfo;
   struct ObjRec *pObj;
{
   return ((ObjInVisibleLayerFunc*)(
         pUserInfo->stProtocolInfo_1.pfnObjInVisibleLayer))(pObj);
}

static
char *Call_UtilStrDup(pUserInfo, pszStr)
   UserInfo *pUserInfo;
   char *pszStr;
{
   return ((UtilStrDupFunc*)(
         pUserInfo->stProtocolInfo_1.pfnUtilStrDup))(pszStr);
}

static
void Call_UtilFree(pUserInfo, pszStr)
   UserInfo *pUserInfo;
   char *pszStr;
{
   ((UtilFreeFunc*)(pUserInfo->stProtocolInfo_1.pfnUtilFree))(pszStr);
}

static
void Call_Msg(pUserInfo, pszMsg)
   UserInfo *pUserInfo;
   char *pszMsg;
{
   ((MsgFunc*)(pUserInfo->stProtocolInfo_1.pfnMsg))(pszMsg);
}

static
void Call_SetStringStatus(pUserInfo, pszMsg)
   UserInfo *pUserInfo;
   char *pszMsg;
{
   ((SetStringStatusFunc*)(pUserInfo->stProtocolInfo_1.pfnSetStringStatus))(
         pszMsg);
}

static
void Call_UtilTrimBlanks(pUserInfo, pszStr)
   UserInfo *pUserInfo;
   char *pszStr;
{
   ((UtilTrimBlanksFunc*)(pUserInfo->stProtocolInfo_1.pfnUtilTrimBlanks))(
         pszStr);
}

static
void Call_DynStrSet(pUserInfo, pDestDynStr, pszStr)
   UserInfo *pUserInfo;
   struct DynStrRec *pDestDynStr;
   char *pszStr;
{
   ((DynStrSetFunc*)(pUserInfo->stProtocolInfo_1.pfnDynStrSet))(
         pDestDynStr, pszStr);
}

/* --------------------- INIT handler --------------------- */

long Bar_Init()
{
#ifdef _DEBUG
   fprintf(stderr, "%s: Got TGEF_MSG_INIT.\n", THIS_EXPORT_FILTER_NAME);
#endif /* _DEBUG */
   return TGEF_STATUS_OK;
}

/* --------------------- CLEANUP handler --------------------- */

long Bar_CleanUp()
{
#ifdef _DEBUG
   fprintf(stderr, "%s: Got TGEF_MSG_CLEANUP.\n", THIS_EXPORT_FILTER_NAME);
#endif /* _DEBUG */
   return TGEF_STATUS_OK;
}

/* --------------------- GET_PROTOCOL_VERSION handler --------------------- */

long Bar_GetProtocolVersion()
{
#ifdef _DEBUG
   fprintf(stderr, "%s: Got TGEF_MSG_GET_PROTOCOL_VERSION.\n",
         THIS_EXPORT_FILTER_NAME);
#endif /* _DEBUG */
   return (long)nTgEFVersion;
}

/* --------------------- LOAD handler --------------------- */

long Bar_Load(ppUserInfo, pProtocolInfo_1)
   TGEF_USER_INFO *ppUserInfo;
   TgEFProtocolInfo_1 *pProtocolInfo_1;
{
   UserInfo *pUserInfo=NULL;

#ifdef _DEBUG
   char spec[MAXSTRING];

   fprintf(stderr, "%s: Got TGEF_MSG_LOAD.\n", THIS_EXPORT_FILTER_NAME);
#endif /* _DEBUG */
   if (ppUserInfo == NULL || pProtocolInfo_1 == NULL) {
      return TGEF_STATUS_INVALID_ARGS;
   }
   /*
    * There is only one memory allocation here.  This is deallocated
    *       in Bar_UnLoad().
    */
   pUserInfo = (UserInfo*)malloc(sizeof(UserInfo));
   if (pUserInfo == NULL) return TGEF_STATUS_MALLOC;

   *ppUserInfo = pUserInfo;
   memset(pUserInfo, 0, sizeof(UserInfo));
   memcpy(&pUserInfo->stProtocolInfo_1, pProtocolInfo_1,
         sizeof(TgEFProtocolInfo_1));

#ifdef _DEBUG
*spec = '\0';
Call_Dialog(pUserInfo, "Input something", NULL, spec);
Call_UtilTrimBlanks(pUserInfo, spec);
sprintf(msg_buf(pUserInfo), "``%s''", spec);
Call_MsgBox(pUserInfo, msg_buf(pUserInfo), THIS_EXPORT_FILTER_NAME, INFO_MB);
#endif /* _DEBUG */
   pProtocolInfo_1->bm_bits = (char*)bar_bits;
   pProtocolInfo_1->bm_width = bar_width;
   pProtocolInfo_1->bm_height = bar_height;
   strncpy(pProtocolInfo_1->color_format_name, THIS_COLOR_EXPORT_FILTER_NAME,
         sizeof(pProtocolInfo_1->color_format_name));
   pProtocolInfo_1->color_format_name[
         sizeof(pProtocolInfo_1->color_format_name)-1] = '\0';
   strncpy(pProtocolInfo_1->bw_format_name, THIS_BW_EXPORT_FILTER_NAME,
         sizeof(pProtocolInfo_1->bw_format_name));
   pProtocolInfo_1->bw_format_name[
         sizeof(pProtocolInfo_1->bw_format_name)-1] = '\0';
   strncpy(pProtocolInfo_1->color_ext, THIS_COLOR_EXPORT_FILTER_EXT,
         sizeof(pProtocolInfo_1->color_ext));
   pProtocolInfo_1->color_ext[
         sizeof(pProtocolInfo_1->color_ext)-1] = '\0';
   strncpy(pProtocolInfo_1->bw_ext, THIS_BW_EXPORT_FILTER_EXT,
         sizeof(pProtocolInfo_1->bw_ext));
   pProtocolInfo_1->bw_ext[
         sizeof(pProtocolInfo_1->bw_ext)-1] = '\0';
   pProtocolInfo_1->capability = TGEF_CAP_MULTI_PAGE;

   return TGEF_STATUS_OK;
}

/* --------------------- UNLOAD handler --------------------- */

long Bar_UnLoad(pTgEFUserInfo)
   TGEF_USER_INFO pTgEFUserInfo;
{
#ifdef _DEBUG
   fprintf(stderr, "%s: Got TGEF_MSG_UNLOAD.\n", THIS_EXPORT_FILTER_NAME);
#endif /* _DEBUG */
   if (pTgEFUserInfo != NULL) {
      UserInfo *pUserInfo=(UserInfo*)pTgEFUserInfo;
      TgEFProtocolInfo_1 *pProtocolInfo_1=(&pUserInfo->stProtocolInfo_1);

      if (pProtocolInfo_1 != NULL) {
         /*
          * Is there anything to clean up here?
          */
      }
      /*
       * There is only one memory deallocation here.  This memory is
       *       allocated in Bar_Load().
       */
      free(pUserInfo);
   }
   return TGEF_STATUS_OK;
}

/* --------------------- DO_EXPORT handler --------------------- */

static
void DumpTextObjInAscii(pUserInfo, pProtocolInfo_1, FP, ObjPtr)
   UserInfo *pUserInfo;
   TgEFProtocolInfo_1 *pProtocolInfo_1;
   FILE *FP;
   register struct ObjRec *ObjPtr;
{
   struct TextRec *text_ptr=ObjPtr->detail.t;
   MiniLineInfo *pMiniLine=NULL;

   if (text_ptr->pen == NONEPAT) return;
   for (pMiniLine=text_ptr->minilines.first; pMiniLine != NULL;
         pMiniLine=pMiniLine->next) {
      if (fprintf(FP, "%s\n", pMiniLine->first_block->seg->dyn_str.s) == EOF) {
         pProtocolInfo_1->write_file_failed = TRUE;
      }
   }
}

static
void DumpAttrsInAscii(pUserInfo, pProtocolInfo_1, FP, AttrPtr)
   UserInfo *pUserInfo;
   TgEFProtocolInfo_1 *pProtocolInfo_1;
   FILE *FP;
   register struct AttrRec *AttrPtr;
{
   for ( ; AttrPtr != NULL; AttrPtr=AttrPtr->prev) {
      if (!AttrPtr->shown) {
         continue;
      }
      DumpTextObjInAscii(pUserInfo, pProtocolInfo_1, FP, AttrPtr->obj);
   }
}

static
void DumpAnObjInAscii(pUserInfo, pProtocolInfo_1, FP, ObjPtr)
   UserInfo *pUserInfo;
   TgEFProtocolInfo_1 *pProtocolInfo_1;
   FILE *FP;
   register struct ObjRec *ObjPtr;
{
   switch (ObjPtr->type) {
   case OBJ_POLY:
   case OBJ_BOX:
   case OBJ_OVAL:
   case OBJ_POLYGON:
   case OBJ_ARC:
   case OBJ_RCBOX:
   case OBJ_XBM:
   case OBJ_XPM:
      if (!pProtocolInfo_1->color_layers || ObjPtr->tmp_parent!=NULL ||
            Call_ObjInVisibleLayer(pUserInfo, ObjPtr)) {
         DumpAttrsInAscii(pUserInfo, pProtocolInfo_1, FP, ObjPtr->lattr);
      }
      break;
   case OBJ_TEXT:
      if (!pProtocolInfo_1->color_layers || ObjPtr->tmp_parent!=NULL ||
            Call_ObjInVisibleLayer(pUserInfo, ObjPtr)) {
         DumpTextObjInAscii(pUserInfo, pProtocolInfo_1, FP, ObjPtr);
      }
      break;
   case OBJ_SYM:
   case OBJ_ICON:
   case OBJ_GROUP:
      if (!pProtocolInfo_1->color_layers || ObjPtr->tmp_parent!=NULL ||
            Call_ObjInVisibleLayer(pUserInfo, ObjPtr)) {
         struct ObjRec *obj_ptr=ObjPtr->detail.r->last;

         for ( ; obj_ptr != NULL; obj_ptr = obj_ptr->prev) {
            obj_ptr->tmp_parent = ObjPtr;
            DumpAnObjInAscii(pUserInfo, pProtocolInfo_1, FP, obj_ptr);
         }
         DumpAttrsInAscii(pUserInfo, pProtocolInfo_1, FP, ObjPtr->lattr);
      }
      break;
   case OBJ_PIN:
      if (!pProtocolInfo_1->color_layers || ObjPtr->tmp_parent!=NULL ||
            Call_ObjInVisibleLayer(pUserInfo, ObjPtr)) {
         struct ObjRec *obj_ptr=GetPinObj(ObjPtr);

         obj_ptr->tmp_parent = ObjPtr;
         DumpAnObjInAscii(pUserInfo, pProtocolInfo_1, FP, obj_ptr);

         DumpAttrsInAscii(pUserInfo, pProtocolInfo_1, FP, ObjPtr->lattr);
      }
      break;
   }
}

static
int DoExport(pUserInfo, pProtocolInfo_1)
   UserInfo *pUserInfo;
   TgEFProtocolInfo_1 *pProtocolInfo_1;
{
   struct ObjRec *obj_ptr=NULL;

   if (pProtocolInfo_1->printing_page_num !=
         pProtocolInfo_1->printing_first_page_num) {
      fprintf(pProtocolInfo_1->fp, "\014\n");
   }
   for (obj_ptr=pProtocolInfo_1->bot_obj; obj_ptr != NULL;
         obj_ptr=obj_ptr->prev) {
      obj_ptr->tmp_parent = NULL;
      DumpAnObjInAscii(pUserInfo, pProtocolInfo_1, pProtocolInfo_1->fp,
            obj_ptr);
   }
   return TRUE;
}

long Bar_DoExport(pTgEFUserInfo, pProtocolInfo_1)
   TGEF_USER_INFO pTgEFUserInfo;
   TgEFProtocolInfo_1 *pProtocolInfo_1;
{
   UserInfo *pUserInfo=(UserInfo*)pTgEFUserInfo;

#ifdef _DEBUG
   fprintf(stderr, "%s: Got TGEF_MSG_DO_EXPORT.\n", THIS_EXPORT_FILTER_NAME);
#endif /* _DEBUG */
   if (pUserInfo) { }

   /*
    * Ignore color_dump for now because we are just dumping text.
    */
   if (pProtocolInfo_1->color_dump) {
   } else {
   }
   if (!DoExport(pUserInfo, pProtocolInfo_1)) {
      return TGEF_STATUS_UNKNOWN;
   }
   return TGEF_STATUS_OK;
}

