/*
 * Copyright 1997 by Yu Mingjian.          All Rights Reserved
 *
 * Permission to retain, use, modify, copy, and distribute Chinput1.0
 * in source or binary and its documentation (hereafter, the Software)
 * for noncommercial purpose is hereby granted to you without a fee,
 * provided that this entire copyright and permission notice appear in
 * all such copies, that no charge be associated with such copies,
 * that distribution of derivative works (including value-added
 * distributions such as with additional input dictionaries or fonts)
 * include clarification that such added or derived parts are not from
 * the original Software, and that the names of the author(s) not be
 * used to endorse or promote such works. The author(s) of the software
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * THE AUTHOR(S) OF THE SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR(S) OF THE SOFTWARE BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Yu Mingjian, Institute of High Energy Physics, Academia Sinica
 * 
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/chinput.c,v 1.2 2011/06/14 02:32:18 william Exp $
 */

#ifndef _NO_CHINPUT

#define _INCLUDE_FROM_CHINPUT_C_

#include "tgifdefs.h"

#include "chinput.e"
#include "strtbl.e"

#define HZINPUT_CLIENT_VERSION		"1.21"
#define HZINPUT_SERVER_VERSION  	"1.21"
#define HZINPUT_SERVER_PROTOCOL		"CHINESE_CONVERSION"

#define HZSERVER_ENCODING_GB		0
#define HZSERVER_ENCODING_BIG5		1
#define HZSERVER_ENCODING_JIS		2
#define HZSERVER_ENCODING_KS		3
#define HZSERVER_ENCODING_UNKNOWN	(-1)

#define HZCLIENT_QUERY_PROTOCOL		0
#define HZCLIENT_QUERY_VERSION		1
#define HZCLIENT_QUERY_ENCODING		2
#define HZCLIENT_QUERY_INPUTMETHOD	3
#define HZCLIENT_QUERY_STATUS		4
#define HZCLIENT_QUERY_UNKNOWN		(-1)

#define HZCLIENT_CONFIG_DEFAULTCOLOR	0
#define HZCLIENT_CONFIG_DIMCOLOR	1
#define HZCLIENT_CONFIG_LIGHTCOLOR	2
#define HZCLIENT_CONFIG_PANELCOLOR	3
#define HZCLIENT_CONFIG_TEXTCOLOR	4
#define HZCLIENT_CONFIG_HZFONT		5
#define HZCLIENT_CONFIG_FONT		6
#define HZCLIENT_CONFIG_INMETHOD	7
#define HZCLIENT_CONFIG_ENCODING	8
#define HZCLIENT_CONFIG_DICTIONARY	9
#define HZCLIENT_CONFIG_ASSOCIATION	10
#define HZCLIENT_CONFIG_LOCKWINDOW	11
#define HZCLIENT_CONFIG_RELEASEWINDOW   12
#define HZCLIENT_CONFIG_PLUGIN		13
#define HZCLIENT_CONFIG_FREEWIN		14
#define HZCLIENT_CONFIG_CLOSE           15

#define HZSERVER_STATUS_DISABLED        0
#define HZSERVER_STATUS_ENABLED         1

#define HZSERVER_KEYBOARD_NULL			0
#define HZSERVER_KEYBOARD_SYMBOL_NUMERIC	1
#define HZSERVER_KEYBOARD_QJ_PY			2
#define HZSERVER_KEYBOARD_JAPANESE		3
#define HZSERVER_KEYBOARD_GREEK_RUSSIAN		4
#define HZSERVER_KEYBOARD_TABLE			5

#define HZSERVER_OUTPUT_NORMAL_KEY		0
#define HZSERVER_OUTPUT_FUNCTION_KEY		1
#define HZSERVER_OUTPUT_HANZI			2
#define HZSERVER_OUTPUT_BAD			-1

#define HZSERVER_INPUT_METHOD_DISABLE		-1
#define HZSERVER_INPUT_METHOD_ENABLE		-2

#define HZSERVER_INPUT_METHOD_ASCII		1
#define HZSERVER_INPUT_METHOD_IC		2
#define HZSERVER_INPUT_METHOD_QW                3
#define HZSERVER_INPUT_METHOD_TONEPY            4
#define HZSERVER_INPUT_METHOD_QJ                5
#define HZSERVER_INPUT_METHOD_PUNCT             6
#define HZSERVER_INPUT_METHOD_PY                7
#define HZSERVER_INPUT_METHOD_CCDOSPY           8
#define HZSERVER_INPUT_METHOD_WUBI              9
#define HZSERVER_INPUT_METHOD_CANGJIE           10
#define HZSERVER_INPUT_METHOD_ENGLISH           11
#define HZSERVER_INPUT_METHOD_CTLAU             12
#define HZSERVER_INPUT_METHOD_SW                13
#define HZSERVER_INPUT_METHOD_QIANMA            14
#define HZSERVER_INPUT_METHOD_TELECODE          15
#define HZSERVER_INPUT_METHOD_HIRAGANA          16
#define HZSERVER_INPUT_METHOD_KATAKANA          17

/*
#define HZSERVER_INPUT_METHOD_ASCII             1
#define HZSERVER_INPUT_METHOD_IC                2
#define HZSERVER_INPUT_METHOD_PY                3
#define HZSERVER_INPUT_METHOD_QJ                4
#define HZSERVER_INPUT_METHOD_PUNCT             5
*/
#define HZSERVER_INPUT_METHOD_ETZY              6
#define HZSERVER_INPUT_METHOD_ZOZY              7
#define HZSERVER_INPUT_METHOD_SIMPLEX           8
/*
#define HZSERVER_INPUT_METHOD_CANGJIE           9
#define HZSERVER_INPUT_METHOD_ENGLISH           10
*/
#define HZSERVER_INPUT_METHOD_4CORNER           11
#define HZSERVER_INPUT_METHOD_HSU               12
#define HZSERVER_INPUT_METHOD_ARRAY30           13
#define HZSERVER_INPUT_METHOD_BOSHIAMY          14

/*
#define HZSERVER_INPUT_METHOD_ASCII             1
#define HZSERVER_INPUT_METHOD_IC                2
*/
#define HZSERVER_INPUT_METHOD_ROMAKANA          3
#define HZSERVER_INPUT_METHOD_TCODE             4
/*
#define HZSERVER_INPUT_METHOD_QJ                5
#define HZSERVER_INPUT_METHOD_PUNCT             6
*/

/*
#define HZSERVER_INPUT_METHOD_ASCII             1
#define HZSERVER_INPUT_METHOD_IC                2
*/
#define HZSERVER_INPUT_METHOD_HANGUL            3
#define HZSERVER_INPUT_METHOD_HANJA             4
/*
#define HZSERVER_INPUT_METHOD_QJ                5
#define HZSERVER_INPUT_METHOD_PUNCT             6
*/

#define HZ_PROTOCOL_ATOM 	"_CHINESE_CONVERSION"
#define HZ_TOOLBAR_ATOM		"_HZ_TOOLBAR_ATOM"
#define HZ_INPUT_ATOM           "_HZ_INPUT_ATOM"
#define HZ_OUTPUT_ATOM          "_HZ_OUTPUT_ATOM"
#define HZ_CONFIG_ATOM		"_HZ_CONFIG_ATOM"
#define HZ_QUERY_ATOM		"_HZ_QUERY_ATOM"
#define HZ_REPLY_ATOM		"_HZ_REPLY_ATOM"

/* input event 
	destination: server window
	event.xclient.message_type = hz_input_atom
	event.xclient.format = 32
	event.xclient.data.l[0] = keysym;
	event.xclient.data.l[1] = key_status_mask;
	event.xclient.data.l[2...4] unused

	if server not loaded, then the client will send itself a client
	event for the client to process conveniently....

        destination: client window
        event.xclient.message_type = hz_output_atom
        event.xclient.format = 32
        event.xclient.data.b[0] = 1;
        event.xclient.data.l[1] = keysym;
	event.xclient.data.l[2] = status(modifier)
        event.xclient.data.l[3...4] unused

*/

/* output event
	destination: client window
	event.xclient.message_type = hz_output_atom
	event.xclient.format = 32
	event.xclient.data.b[0] = total_chars_converted;
	event.xclient.data.b[1] = charbuf...
*/

/* query event 
        destination: server window
        event.xclient.message_type = hz_query_atom
        event.xclient.format = 32
        event.xclient.data.l[0] = query_type;
	event.xclient.data.l[1...4] unused
	query_type:
		HZCLIENT_QUERY_PROTOCOL         0
		HZCLIENT_QUERY_VERSION          1
		HZCLIENT_QUERY_ENCODING         2
		HZCLIENT_QUERY_STATUS           3
*/

/* reply event
        destination: client window
        event.xclient.message_type = hz_reply_atom
        event.xclient.format = 32
        event.xclient.data.b[0] = reply_type;
	event.xclient.data.b[1...] = answer
	....

*/

/* config event
	destination: server window
	event.xclient.message_type = hz_config_atom
        event.xclient.format = 32
        event.xclient.data.l[0] = config_type;
	config_type:
		HZSERVER_CONFIG_FGCOLOR         1
		HZSERVER_CONFIG_BGCOLOR         2
		HZSERVER_CONFIG_PANELCOLOR      3
		HZSERVER_CONFIG_ENCODING        4
		HZSERVER_CONFIG_INPUTMTHD       5
		HZSERVER_CONFIG_INPUTKBD        6
		color type:
			event.xclient.data.l[1] = red
			event.xclient.data.l[2] = green
			event.xclient.data.l[3] = blue
		encoding type:
			event.xclient.data.l[1] = encoding_type
		input method type:
			event.xclient.data.l[1] = encoding_method
		input keyboard type:
			event.xclient.data.l[1] = keyboard_type;
*/

static Atom hz_protocol_atom=(Atom)0;	/* protocol atom marking the server     */
Atom hz_toolbar_atom=(Atom)0;	/* protocol atom for toolbar            */
static Atom hz_input_atom=(Atom)0;	/* atom for key press                   */
static Atom hz_output_atom=(Atom)0;	/* atom for output from the server      */
static Atom hz_query_atom=(Atom)0;	/* query server                         */
static Atom hz_reply_atom=(Atom)0;	/* reply client query                   */
static Atom hz_config_atom=(Atom)0;	/* config server attributes and state   */

int HZclientInit(dpy)
/* 
	argument: null
   	return:   0 success, 1: failed
*/
Display *dpy;
{
        hz_protocol_atom = XInternAtom(dpy, HZ_PROTOCOL_ATOM, False);
        hz_input_atom    = XInternAtom(dpy, HZ_INPUT_ATOM,    False);
        hz_output_atom   = XInternAtom(dpy, HZ_OUTPUT_ATOM,   False);
        hz_query_atom    = XInternAtom(dpy, HZ_QUERY_ATOM,    False);
        hz_reply_atom    = XInternAtom(dpy, HZ_REPLY_ATOM,    False);
	hz_config_atom   = XInternAtom(dpy, HZ_CONFIG_ATOM,   False);
	return 0;

}

static int HZprocInput(ev, number, keycode, keystate, str)
/* 
	argument: clientevent
		  number	number chars returned by server(or client)
		  code		key code returned
		  state		key state(modifier)
		  str		string buffer(hanzi)
   	return:   -1 nothing happened
		  0 normal key;
		  1 function key;
		  2 string
*/
XClientMessageEvent *ev;
int *number; 
unsigned int *keycode, *keystate;
char *str;
{
/*	int i; */
	char *buf = ev->data.b;

        if (ev->message_type != hz_output_atom) return -1;

	memset(str, '\0', 20);
	strncpy(str, buf+1, ev->data.b[0]);
	*number = ev->data.b[0];

	/* only one char */
	if(ev->data.b[0] == 1) {
		*keycode = ev->data.l[1];

		/* function key, or control keys */
		if(ev->data.l[1] & 0xff00 || (ev->data.l[2] & ControlMask)) {
			*keystate = ev->data.l[2];
			return HZSERVER_OUTPUT_FUNCTION_KEY;
		}

		/* normal keys */
		else return HZSERVER_OUTPUT_NORMAL_KEY;

	/* hanzi string */
	} else 
		return HZSERVER_OUTPUT_HANZI;
	

}

int HZqueryServer(dpy, win, type, str)
/*
	argument: display	display
		  window	client window which want to accept event
		  type		query type
		  str		returned string
	return:   0 -- server not on
		  1 -- OK
*/
Display *dpy;
Window win;
int type;
char *str;
{
	Window twin;
	XEvent report;
        XClientMessageEvent event;
        hz_protocol_atom = XInternAtom(dpy, HZ_PROTOCOL_ATOM,False);

        twin = XGetSelectionOwner(dpy,hz_protocol_atom);
        if(twin == None){
                strcpy(str, "");
                return 0;
	}
        event.type=ClientMessage;
        event.window=win;
        event.message_type=hz_query_atom;
        event.format=32;
        event.data.l[0] = type;
        XSendEvent(dpy, twin, False, 0, (XEvent *)&event);
        XSync(dpy,False);

	while(1){
		XNextEvent(dpy, &report);
		switch(report.type){
		case ClientMessage:
			if(report.xclient.message_type == hz_reply_atom &&
				report.xclient.data.b[0] == type)
		        strcpy(str, &report.xclient.data.b[1]);
			return 1;
		default:
			break;
		}	
	}
}



int HZsendKey(dpy, win, eve)
/*
	argument: dpy		display
		  win		client window
		  event		send keypress event
	return:   0 -- server not on
		  1 -- OK
*/
Display *dpy;
Window win;
XKeyEvent *eve;
{
	Window twin;
	XClientMessageEvent event;
        char bf[20];
        int  bfsize = 20;
        KeySym keysym;
        XComposeStatus compose;
        int charcount;

	hz_protocol_atom = XInternAtom(dpy, HZ_PROTOCOL_ATOM,False);
	twin = XGetSelectionOwner(dpy,hz_protocol_atom);

        charcount = XLookupString(eve, bf,
                bfsize, &keysym, &compose);

	if(twin == None || (eve->state & ControlMask) ) {
		event.type = ClientMessage;
        	event.window = win;
        	event.message_type=hz_output_atom;
        	event.format=32;
        	event.data.b[0] = 1;
        	event.data.l[1] = keysym;
		event.data.l[2] = eve->state;
	        XSendEvent(dpy, win, False, 0, (XEvent *)&event);
        	XSync(dpy,False);
        	if (twin == None) return 0;
	} else {

		event.type=ClientMessage;
		event.window=win;
		event.message_type=hz_input_atom;
		event.format=32;
		event.data.l[0] = keysym;
		event.data.l[1] = eve->state;

		XSendEvent(dpy, twin, False, 0, (XEvent *)&event);
		XSync(dpy,False);
	}
	return 1;
}

/* configure the server
*/

int HZconfigServer(dpy, win, flag, n1, n2, n3)
/*
	argument: dpy		display
		  win		client window
		  flag		configure type
		  n1,n2,n3	color: red,green,blue
	return:   0 -- failed
		  1 -- OK
*/
Display *dpy;
Window  win;
int flag;		/* configure type */
int n1, n2, n3;		/* for color n1,n2,n3 = red,green,blue
			   for input method n1 = method, n2, n3 not used */
{
	
        Window twin;
        XClientMessageEvent event;

        hz_protocol_atom = XInternAtom(dpy, HZ_PROTOCOL_ATOM,False);
        twin = XGetSelectionOwner(dpy,hz_protocol_atom);

        if(twin == None) {
		printf("%s\n", TgLoadString(STID_SERVER_NOT_STARTED));
		return 0;
	}

        event.type = ClientMessage;
        event.window = win;
        event.message_type=hz_config_atom;
        event.format=32;
        event.data.l[0] = flag;
        event.data.l[1] = n1;
        event.data.l[2] = n2;
        event.data.l[3] = n3;
        XSendEvent(dpy, twin, False, 0, (XEvent *)&event);

        return 1;

}

/* --------------------- Added by Bill Cheng --------------------- */

int Tg_HZclientInit(dpy)
   Display *dpy;
{
   return HZclientInit(dpy);
}

int Tg_HZsendKey(dpy, win, eve)
   Display *dpy;
   Window win;
   XKeyEvent *eve;
{
   return HZsendKey(dpy, win, eve);
}

int Tg_HZhandleCM(cm_ev, key_ev, buf)
   XClientMessageEvent *cm_ev;
   XKeyEvent *key_ev;
   char *buf;
{
   char s1[80];
   int num=0, rc=0;

   rc = HZprocInput(cm_ev, &num, &key_ev->keycode, &key_ev->state, s1);

   if (rc == HZSERVER_OUTPUT_BAD) {
      return FALSE;
   } else if (rc == HZSERVER_OUTPUT_NORMAL_KEY) {
      buf[0] = key_ev->keycode;
      buf[1] = '\0';
   } else if (rc == HZSERVER_OUTPUT_FUNCTION_KEY) {
      buf[0] = '\0';
   } else if (rc == HZSERVER_OUTPUT_HANZI) {
      strncpy(buf, s1, num);
      buf[num] = '\0';
   }
   return TRUE;
}

#endif /* ~_NO_CHINPUT */
