/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2006, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/tdgtbrow.e,v 1.3 2006/02/10 23:21:21 william Exp $
 */

#ifndef _TDGTBROW_E_
#define _TDGTBROW_E_

#include "tidget.h"

#include "tdgtbtn.e"
#include "list.e"

#define TDGTBROW_DEF_H_PAD 2
#define TDGTBROW_DEF_V_PAD 2

/*
 * A button row tidget is a container of which other buttons can sit on top.
 */
typedef struct tagTdgtBtnRow {
   TidgetInfo *pti;

   SimpleWinInfo client_area;

   int content_w, content_h; /* the area occupied by the buttons */
   int h_gap;
   int just; /* JUST_L, JUST_C, or JUST_R */
} TdgtBtnRow;

#ifdef _INCLUDE_FROM_TDGTBROW_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_TDGTBROW_C_*/

extern void	TdgtBtnRowReset ARGS_DECL((TdgtBtnRow*));
extern TdgtBtnRow	*CreateTdgtBtnRow ARGS_DECL((Window parent_win,
				TidgetInfo *parent_tidgetinfo, int ctl_id,
				int x, int y, int h_pad, int v_pad, int state,
				int h_gap, int just));

extern int	TdgtBtnRowAddBtn ARGS_DECL((TdgtBtnRow*, TdgtBtn*));

extern int	InitTdgtBtnRow ARGS_DECL((void));
extern void	CleanUpTdgtBtnRow ARGS_DECL((void));

#ifdef _INCLUDE_FROM_TDGTBROW_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_TDGTBROW_C_*/

#endif /*_TDGTBROW_E_*/
