/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2005, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/tdgtsedt.e,v 1.2 2005/01/15 00:23:23 william Exp $
 */

#ifndef _TDGTSEDT_E_
#define _TDGTSEDT_E_

#include "tidget.h"

#define TDGTSEDT_DEF_H_PAD 2
#define TDGTSEDT_DEF_V_PAD 1

/*
 * A simple edit tidget is left-justitified, single-line, and single-color.
 */
typedef struct tagTdgtSmplEdit {
   TidgetInfo *pti;

   SimpleWinInfo client_area;

   int font_style; /* can be STYLE_NR, STYLE_BR, STYLE_NI, or STYLE_BI */
   int color_index;
   char color_str[40];

   int cursor_shown;

   int w, h, min_lbearing, max_rextra, x_start;

   Pixmap text_pixmap;
} TdgtSmplEdit;

#ifdef _INCLUDE_FROM_TDGTSEDT_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_TDGTSEDT_C_*/

extern void	TdgtSmplEditReset ARGS_DECL((TdgtSmplEdit*));
extern TdgtSmplEdit	*CreateTdgtSmplEdit ARGS_DECL((Window parent_win,
				TidgetInfo *parent_tidgetinfo, int ctl_id,
				int x, int y, int w, int h_pad, int v_pad,
				char *caption, int font_style,
				int color_index));

extern int	TdgtSmplEditSetText ARGS_DECL((TdgtSmplEdit*, char *str));
extern char	*TdgtSmplEditGetText ARGS_DECL((TdgtSmplEdit*));
extern void	TdgtSmplEditGetTextFormatInfo ARGS_DECL((TdgtSmplEdit*,
				TextFormatInfo*));
extern int	TdgtSmplEditSetColorIndex ARGS_DECL((TdgtSmplEdit*, int));
extern int	TdgtSmplEditGetColorIndex ARGS_DECL((TdgtSmplEdit*));
extern int	TdgtSmplEditSetFontStyle ARGS_DECL((TdgtSmplEdit*, int));
extern int	TdgtSmplEditGetFontStyle ARGS_DECL((TdgtSmplEdit*));

extern int	TdgtSmplEditAppendStr ARGS_DECL((TdgtSmplEdit*, char *str,
				int len));
extern int	TdgtSmplEditDelLastChar ARGS_DECL((TdgtSmplEdit*));

extern void	TdgtSmplEditSetFocus ARGS_DECL((TdgtSmplEdit*, int nSet));

extern int	InitTdgtSmplEdit ARGS_DECL((void));
extern void	CleanUpTdgtSmplEdit ARGS_DECL((void));

#ifdef _INCLUDE_FROM_TDGTSEDT_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_TDGTSEDT_C_*/

#endif /*_TDGTSEDT_E_*/
