/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2005, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/pattern.e,v 1.2 2005/01/15 00:23:23 william Exp $
 */

#ifndef _PATTERN_E_
#define _PATTERN_E_

extern int	objFill;
extern int	transPat;
extern int	lineStyle;
extern int	lineWidth;
extern int	penPat;
extern int	curSpline;
extern int	curDash;
extern int	rcbRadius;
extern int	useGray;
extern char	patternStr[];

extern int	stickyMenuSelection;

#ifdef _INCLUDE_FROM_PATTERN_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_PATTERN_C_*/

extern void	ResetGrayDetection ARGS_DECL((void));
extern char	* GrayStr ARGS_DECL((int Index));
extern void	GrayCheck ARGS_DECL((int Index));
extern void	EndGrayDetection ARGS_DECL((void));

extern int	RefreshModeMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateModeMenu ARGS_DECL((TgMenu*, int X, int Y, TgMenuInfo*,
		                           int status_str_xlated));
extern int	ModeMenu ARGS_DECL((int X, int Y, int TrackMenubar));

extern int	ChangeObjTransPat ARGS_DECL((struct ObjRec *, int FillIndex));
extern void	ChangeAllSelTransPat ARGS_DECL((int Index, int HighLight));

extern int	ChangeObjFill ARGS_DECL((struct ObjRec *, int FillIndex));
extern void	ChangeAllSelFill ARGS_DECL((int Index, int HighLight));
extern void	RefreshFillMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateFillMenu ARGS_DECL((TgMenu*, int X, int Y, TgMenuInfo*,
		                           int status_str_xlated));
extern int	FillMenu ARGS_DECL((int X, int Y, int TrackMenubar));

extern void	ChangeAllSelLineStyle ARGS_DECL((int Index, int HighLight));
extern void	RefreshLineStyleMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateLineStyleMenu ARGS_DECL((TgMenu*, int X, int Y,
		                                TgMenuInfo*,
		                                int status_str_xlated));
extern int	LineStyleMenu ARGS_DECL((int X, int Y, int TrackMenubar));

extern void	ChangeAllSelLineType ARGS_DECL((int Index, int HighLight));
extern void	RefreshLineTypeMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateLineTypeMenu ARGS_DECL((TgMenu*, int X, int Y,
		                               TgMenuInfo*,
		                               int status_str_xlated));
extern int	LineTypeMenu ARGS_DECL((int X, int Y, int TrackMenubar));

extern void	ChangeAllSelLineWidth ARGS_DECL((int Index, int HighLight));
extern int	GetBestLineWidthIndex ARGS_DECL((int width, int aw, int ah));
extern void	RefreshLineWidthMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateLineWidthMenu ARGS_DECL((TgMenu*, int X, int Y,
		                                TgMenuInfo*,
		                                int status_str_xlated));
extern int	LineWidthMenu ARGS_DECL((int X, int Y, int TrackMenubar));

extern void	ChangeAllSelLineDash ARGS_DECL((int Index, int HighLight));
extern void	RefreshLineDashMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateLineDashMenu ARGS_DECL((TgMenu*, int X, int Y,
		                                TgMenuInfo*,
		                                int status_str_xlated));
extern int	LineDashMenu ARGS_DECL((int X, int Y, int TrackMenubar));

extern int	ChangeObjPen ARGS_DECL((struct ObjRec *, int PenIndex));
extern void	ChangeAllSelPen ARGS_DECL((int Index, int HighLight));
extern void	RefreshPenMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreatePenMenu ARGS_DECL((TgMenu*, int X, int Y, TgMenuInfo*,
		                          int status_str_xlated));
extern int	PenMenu ARGS_DECL((int X, int Y, int TrackMenubar));

extern void	ToggleAllSelLineType ARGS_DECL((void));
extern void	ChangeAllSelRCBRadius ARGS_DECL((int Radius));
extern void	UpdateSelObjs ARGS_DECL((void));
extern void	ChangeAllSelRealLineWidth ARGS_DECL((int nMask,
		                                     int Width, int AW, int AH,
		                                     char*, char*, char*,
		                                     int HighLight));
extern void	SetSelLineWidth ARGS_DECL((char*));

#ifdef _INCLUDE_FROM_PATTERN_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_PATTERN_C_*/

#endif /*_PATTERN_E_*/
