/*
 * Author:      William Chia-Wei Cheng (bill.cheng@acm.org)
 *
 * Copyright (C) 1990-2005, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm2/home/cvs/bc-src/tgif/choice.e,v 1.2 2005/01/15 00:23:22 william Exp $
 */

#ifndef _CHOICE_E_
#define _CHOICE_E_

extern int	curChoice;
extern int	cycleThroughChoice;

extern int	setCurChoiceDontUpdateUI;

#ifdef _INCLUDE_FROM_CHOICE_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_CHOICE_C_*/

extern void	InitChoice ARGS_DECL((void));
extern void	CleanUpChoices ARGS_DECL((void));

extern void	ShowColor ARGS_DECL((int PropagateWhereToPrint));
extern void	ShowHoriAlign ARGS_DECL((void));
extern void	ShowVertAlign ARGS_DECL((void));
extern void	ShowJust ARGS_DECL((void));
extern void	ShowCurFont ARGS_DECL((void));
extern void	ShowTextVSpace ARGS_DECL((void));
extern void	ShowZoom ARGS_DECL((void));
extern void	ShowTextSize ARGS_DECL((void));
extern void	ShowRotate ARGS_DECL((void));
extern void	ShowLineWidth ARGS_DECL((void));
extern void	ShowLineStyle ARGS_DECL((void));
extern void	ShowLineType ARGS_DECL((void));
extern void	ShowDash ARGS_DECL((void));
extern void	ShowWhereToPrint ARGS_DECL((void));
extern void	ShowFile ARGS_DECL((void));
extern void	ShowRCBRadius ARGS_DECL((void));
extern void	ShowMoveMode ARGS_DECL((void));
extern void	ShowShape ARGS_DECL((void));
extern void	ShowStretchableTextMode ARGS_DECL((void));
extern void	ShowFill ARGS_DECL((void));
extern void	ShowTransPatMode ARGS_DECL((void));
extern void	ShowPen ARGS_DECL((void));
extern void	ShowPage ARGS_DECL((void));
extern void	ShowPageLayout ARGS_DECL((void));

extern void	ShowCurChoiceMouseStatus ARGS_DECL((int choice,
		                                    unsigned int state,
		                                    int cur_text_under_mouse));
extern void	SetCurChoice ARGS_DECL((int NewChoice));
extern void	PushCurChoice ARGS_DECL((void));
extern void	FormatFloat ARGS_DECL((float *pfval, char *buf));
extern void	FormatAngle ARGS_DECL((int DegreeTimes64, char *buf));
extern int	ChoiceEventHandler ARGS_DECL((XEvent *));
extern void	RedrawModeWindow ARGS_DECL((void));
extern int	ModeEventHandler ARGS_DECL((XEvent *));

#ifdef _INCLUDE_FROM_CHOICE_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_CHOICE_C_*/

#endif /*_CHOICE_E_*/
